@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RegexPatternSetRegularExpressionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property regexString The string representing the regular expression, see the AWS WAF [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-regex-pattern-set-creating.html) for more information.
 */
public data class RegexPatternSetRegularExpressionArgs(
    public val regexString: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RegexPatternSetRegularExpressionArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RegexPatternSetRegularExpressionArgs =
        com.pulumi.aws.wafv2.inputs.RegexPatternSetRegularExpressionArgs.builder()
            .regexString(regexString.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegexPatternSetRegularExpressionArgs].
 */
@PulumiTagMarker
public class RegexPatternSetRegularExpressionArgsBuilder internal constructor() {
    private var regexString: Output<String>? = null

    /**
     * @param value The string representing the regular expression, see the AWS WAF [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-regex-pattern-set-creating.html) for more information.
     */
    @JvmName("jtjukeaujqxtnsah")
    public suspend fun regexString(`value`: Output<String>) {
        this.regexString = value
    }

    /**
     * @param value The string representing the regular expression, see the AWS WAF [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-regex-pattern-set-creating.html) for more information.
     */
    @JvmName("gsuekvrgidriewuq")
    public suspend fun regexString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regexString = mapped
    }

    internal fun build(): RegexPatternSetRegularExpressionArgs = RegexPatternSetRegularExpressionArgs(
        regexString = regexString ?: throw PulumiNullFieldException("regexString"),
    )
}
