@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property allow Instructs AWS WAF to allow the web request. See Allow below for details.
 * @property block Instructs AWS WAF to block the web request. See Block below for details.
 * @property captcha Instructs AWS WAF to run a `CAPTCHA` check against the web request. See Captcha below for details.
 * @property challenge Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See Challenge below for details.
 * @property count Instructs AWS WAF to count the web request and allow it. See Count below for details.
 */
public data class RuleGroupRuleActionArgs(
    public val allow: Output<RuleGroupRuleActionAllowArgs>? = null,
    public val block: Output<RuleGroupRuleActionBlockArgs>? = null,
    public val captcha: Output<RuleGroupRuleActionCaptchaArgs>? = null,
    public val challenge: Output<RuleGroupRuleActionChallengeArgs>? = null,
    public val count: Output<RuleGroupRuleActionCountArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionArgs.builder()
            .allow(allow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .block(block?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .captcha(captcha?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .challenge(challenge?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .count(count?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RuleGroupRuleActionArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleActionArgsBuilder internal constructor() {
    private var allow: Output<RuleGroupRuleActionAllowArgs>? = null

    private var block: Output<RuleGroupRuleActionBlockArgs>? = null

    private var captcha: Output<RuleGroupRuleActionCaptchaArgs>? = null

    private var challenge: Output<RuleGroupRuleActionChallengeArgs>? = null

    private var count: Output<RuleGroupRuleActionCountArgs>? = null

    /**
     * @param value Instructs AWS WAF to allow the web request. See Allow below for details.
     */
    @JvmName("whvgkfxmyfnxjymh")
    public suspend fun allow(`value`: Output<RuleGroupRuleActionAllowArgs>) {
        this.allow = value
    }

    /**
     * @param value Instructs AWS WAF to block the web request. See Block below for details.
     */
    @JvmName("dnnjjtqxpgumgmjd")
    public suspend fun block(`value`: Output<RuleGroupRuleActionBlockArgs>) {
        this.block = value
    }

    /**
     * @param value Instructs AWS WAF to run a `CAPTCHA` check against the web request. See Captcha below for details.
     */
    @JvmName("jobkvrougpvmmuvm")
    public suspend fun captcha(`value`: Output<RuleGroupRuleActionCaptchaArgs>) {
        this.captcha = value
    }

    /**
     * @param value Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See Challenge below for details.
     */
    @JvmName("ajsxcnicvmmwigul")
    public suspend fun challenge(`value`: Output<RuleGroupRuleActionChallengeArgs>) {
        this.challenge = value
    }

    /**
     * @param value Instructs AWS WAF to count the web request and allow it. See Count below for details.
     */
    @JvmName("eimkaltmgbanhede")
    public suspend fun count(`value`: Output<RuleGroupRuleActionCountArgs>) {
        this.count = value
    }

    /**
     * @param value Instructs AWS WAF to allow the web request. See Allow below for details.
     */
    @JvmName("kljateolegvonlde")
    public suspend fun allow(`value`: RuleGroupRuleActionAllowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param argument Instructs AWS WAF to allow the web request. See Allow below for details.
     */
    @JvmName("fnakvohktqacwnnu")
    public suspend fun allow(argument: suspend RuleGroupRuleActionAllowArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleActionAllowArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.allow = mapped
    }

    /**
     * @param value Instructs AWS WAF to block the web request. See Block below for details.
     */
    @JvmName("wafdwjmyftcfwquv")
    public suspend fun block(`value`: RuleGroupRuleActionBlockArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.block = mapped
    }

    /**
     * @param argument Instructs AWS WAF to block the web request. See Block below for details.
     */
    @JvmName("gbgrnrrvhguutjpe")
    public suspend fun block(argument: suspend RuleGroupRuleActionBlockArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleActionBlockArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.block = mapped
    }

    /**
     * @param value Instructs AWS WAF to run a `CAPTCHA` check against the web request. See Captcha below for details.
     */
    @JvmName("wciowftdapetokys")
    public suspend fun captcha(`value`: RuleGroupRuleActionCaptchaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captcha = mapped
    }

    /**
     * @param argument Instructs AWS WAF to run a `CAPTCHA` check against the web request. See Captcha below for details.
     */
    @JvmName("dgbssuthqdevqatp")
    public suspend fun captcha(argument: suspend RuleGroupRuleActionCaptchaArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleActionCaptchaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.captcha = mapped
    }

    /**
     * @param value Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See Challenge below for details.
     */
    @JvmName("xfuloamuthbrghgx")
    public suspend fun challenge(`value`: RuleGroupRuleActionChallengeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.challenge = mapped
    }

    /**
     * @param argument Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See Challenge below for details.
     */
    @JvmName("qqygcjahenjbtqya")
    public suspend fun challenge(argument: suspend RuleGroupRuleActionChallengeArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleActionChallengeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.challenge = mapped
    }

    /**
     * @param value Instructs AWS WAF to count the web request and allow it. See Count below for details.
     */
    @JvmName("hiehckkpxminbqor")
    public suspend fun count(`value`: RuleGroupRuleActionCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param argument Instructs AWS WAF to count the web request and allow it. See Count below for details.
     */
    @JvmName("tihhjhvpyfrjojum")
    public suspend fun count(argument: suspend RuleGroupRuleActionCountArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleActionCountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.count = mapped
    }

    internal fun build(): RuleGroupRuleActionArgs = RuleGroupRuleActionArgs(
        allow = allow,
        block = block,
        captcha = captcha,
        challenge = challenge,
        count = count,
    )
}
