@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionBlockArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customResponse Defines a custom response for the web request. See Custom Response below for details.
 */
public data class RuleGroupRuleActionBlockArgs(
    public val customResponse: Output<RuleGroupRuleActionBlockCustomResponseArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionBlockArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionBlockArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionBlockArgs.builder()
            .customResponse(
                customResponse?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleActionBlockArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleActionBlockArgsBuilder internal constructor() {
    private var customResponse: Output<RuleGroupRuleActionBlockCustomResponseArgs>? = null

    /**
     * @param value Defines a custom response for the web request. See Custom Response below for details.
     */
    @JvmName("htwdniftlbcnbeys")
    public suspend fun customResponse(`value`: Output<RuleGroupRuleActionBlockCustomResponseArgs>) {
        this.customResponse = value
    }

    /**
     * @param value Defines a custom response for the web request. See Custom Response below for details.
     */
    @JvmName("lqqugrmuqlthrixo")
    public suspend fun customResponse(`value`: RuleGroupRuleActionBlockCustomResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customResponse = mapped
    }

    /**
     * @param argument Defines a custom response for the web request. See Custom Response below for details.
     */
    @JvmName("tqkhajpuhluhgcdm")
    public suspend fun customResponse(argument: suspend RuleGroupRuleActionBlockCustomResponseArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleActionBlockCustomResponseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customResponse = mapped
    }

    internal fun build(): RuleGroupRuleActionBlockArgs = RuleGroupRuleActionBlockArgs(
        customResponse = customResponse,
    )
}
