@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCaptchaCustomRequestHandlingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property insertHeaders The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
 */
public data class RuleGroupRuleActionCaptchaCustomRequestHandlingArgs(
    public val insertHeaders: Output<List<RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCaptchaCustomRequestHandlingArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCaptchaCustomRequestHandlingArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionCaptchaCustomRequestHandlingArgs.builder()
            .insertHeaders(
                insertHeaders.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleActionCaptchaCustomRequestHandlingArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleActionCaptchaCustomRequestHandlingArgsBuilder internal constructor() {
    private var insertHeaders:
        Output<List<RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs>>? = null

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("nihoycfbcwkbiarp")
    public suspend fun insertHeaders(`value`: Output<List<RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = value
    }

    @JvmName("bjgytleweaiydlos")
    public suspend fun insertHeaders(vararg values: Output<RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs>) {
        this.insertHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("hysqgfammflnsxcw")
    public suspend fun insertHeaders(values: List<Output<RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = Output.all(values)
    }

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("naybrslqvayptkfx")
    public suspend fun insertHeaders(`value`: List<RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("obwviegwdxepwxwv")
    public suspend fun insertHeaders(argument: List<suspend RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("lgeiweiuhhlhomfp")
    public suspend fun insertHeaders(vararg argument: suspend RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("bpaprrhkbglocvhv")
    public suspend fun insertHeaders(argument: suspend RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("ebnuddmdtdsgsvhh")
    public suspend fun insertHeaders(vararg values: RuleGroupRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    internal fun build(): RuleGroupRuleActionCaptchaCustomRequestHandlingArgs =
        RuleGroupRuleActionCaptchaCustomRequestHandlingArgs(
            insertHeaders = insertHeaders ?: throw PulumiNullFieldException("insertHeaders"),
        )
}
