@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionChallengeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customRequestHandling Defines custom handling for the web request. See Custom Request Handling below for details.
 */
public data class RuleGroupRuleActionChallengeArgs(
    public val customRequestHandling: Output<RuleGroupRuleActionChallengeCustomRequestHandlingArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionChallengeArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionChallengeArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionChallengeArgs.builder()
            .customRequestHandling(
                customRequestHandling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleActionChallengeArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleActionChallengeArgsBuilder internal constructor() {
    private var customRequestHandling: Output<RuleGroupRuleActionChallengeCustomRequestHandlingArgs>? =
        null

    /**
     * @param value Defines custom handling for the web request. See Custom Request Handling below for details.
     */
    @JvmName("rwcdhbapdkvxcnyq")
    public suspend fun customRequestHandling(`value`: Output<RuleGroupRuleActionChallengeCustomRequestHandlingArgs>) {
        this.customRequestHandling = value
    }

    /**
     * @param value Defines custom handling for the web request. See Custom Request Handling below for details.
     */
    @JvmName("rnmkdlgqsiuydejj")
    public suspend fun customRequestHandling(`value`: RuleGroupRuleActionChallengeCustomRequestHandlingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRequestHandling = mapped
    }

    /**
     * @param argument Defines custom handling for the web request. See Custom Request Handling below for details.
     */
    @JvmName("bcfxcxrtyfqbciee")
    public suspend fun customRequestHandling(argument: suspend RuleGroupRuleActionChallengeCustomRequestHandlingArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleActionChallengeCustomRequestHandlingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customRequestHandling = mapped
    }

    internal fun build(): RuleGroupRuleActionChallengeArgs = RuleGroupRuleActionChallengeArgs(
        customRequestHandling = customRequestHandling,
    )
}
