@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionChallengeCustomRequestHandlingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property insertHeaders The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
 */
public data class RuleGroupRuleActionChallengeCustomRequestHandlingArgs(
    public val insertHeaders: Output<List<RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionChallengeCustomRequestHandlingArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionChallengeCustomRequestHandlingArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleActionChallengeCustomRequestHandlingArgs.builder()
            .insertHeaders(
                insertHeaders.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleActionChallengeCustomRequestHandlingArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleActionChallengeCustomRequestHandlingArgsBuilder internal constructor() {
    private var insertHeaders:
        Output<List<RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgs>>? = null

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("vlycstvtyyvpseag")
    public suspend fun insertHeaders(`value`: Output<List<RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = value
    }

    @JvmName("qksdpjmltvjejelt")
    public suspend fun insertHeaders(vararg values: Output<RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgs>) {
        this.insertHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("xgwphbtvyjkelaad")
    public suspend fun insertHeaders(values: List<Output<RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = Output.all(values)
    }

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("ncrbetwjnsstxros")
    public suspend fun insertHeaders(`value`: List<RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("lkhiyqpyargxmngo")
    public suspend fun insertHeaders(argument: List<suspend RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("xcxksexolgynqovf")
    public suspend fun insertHeaders(vararg argument: suspend RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("nvqgutycondrtqmh")
    public suspend fun insertHeaders(argument: suspend RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See Custom HTTP Header below for details.
     */
    @JvmName("pplcakrcjkfmssvv")
    public suspend fun insertHeaders(vararg values: RuleGroupRuleActionChallengeCustomRequestHandlingInsertHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    internal fun build(): RuleGroupRuleActionChallengeCustomRequestHandlingArgs =
        RuleGroupRuleActionChallengeCustomRequestHandlingArgs(
            insertHeaders = insertHeaders ?: throw PulumiNullFieldException("insertHeaders"),
        )
}
