@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleCaptchaConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property immunityTimeProperty Defines custom immunity time. See Immunity Time Property below for details.
 */
public data class RuleGroupRuleCaptchaConfigArgs(
    public val immunityTimeProperty: Output<RuleGroupRuleCaptchaConfigImmunityTimePropertyArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleCaptchaConfigArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleCaptchaConfigArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleCaptchaConfigArgs.builder()
            .immunityTimeProperty(
                immunityTimeProperty?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleCaptchaConfigArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleCaptchaConfigArgsBuilder internal constructor() {
    private var immunityTimeProperty: Output<RuleGroupRuleCaptchaConfigImmunityTimePropertyArgs>? =
        null

    /**
     * @param value Defines custom immunity time. See Immunity Time Property below for details.
     */
    @JvmName("nxqfqutsmmwdsodt")
    public suspend fun immunityTimeProperty(`value`: Output<RuleGroupRuleCaptchaConfigImmunityTimePropertyArgs>) {
        this.immunityTimeProperty = value
    }

    /**
     * @param value Defines custom immunity time. See Immunity Time Property below for details.
     */
    @JvmName("holctqxqfjheddju")
    public suspend fun immunityTimeProperty(`value`: RuleGroupRuleCaptchaConfigImmunityTimePropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immunityTimeProperty = mapped
    }

    /**
     * @param argument Defines custom immunity time. See Immunity Time Property below for details.
     */
    @JvmName("meruqhjynfnbjsrp")
    public suspend fun immunityTimeProperty(argument: suspend RuleGroupRuleCaptchaConfigImmunityTimePropertyArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleCaptchaConfigImmunityTimePropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.immunityTimeProperty = mapped
    }

    internal fun build(): RuleGroupRuleCaptchaConfigArgs = RuleGroupRuleCaptchaConfigArgs(
        immunityTimeProperty = immunityTimeProperty,
    )
}
