@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementByteMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
 * @property positionalConstraint The area within the portion of a web request that you want AWS WAF to search for `search_string`. Valid values include the following: `EXACTLY`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CONTAINS_WORD`. See the AWS [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchStatement.html) for more information.
 * @property searchString A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in `field_to_match`. The maximum length of the value is 50 bytes.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementByteMatchStatementArgs(
    public val fieldToMatch: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchArgs>? = null,
    public val positionalConstraint: Output<String>,
    public val searchString: Output<String>,
    public val textTransformations: Output<List<RuleGroupRuleStatementByteMatchStatementTextTransformationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementByteMatchStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementByteMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementByteMatchStatementArgs.builder()
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .positionalConstraint(positionalConstraint.applyValue({ args0 -> args0 }))
            .searchString(searchString.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementByteMatchStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementByteMatchStatementArgsBuilder internal constructor() {
    private var fieldToMatch: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchArgs>? = null

    private var positionalConstraint: Output<String>? = null

    private var searchString: Output<String>? = null

    private var textTransformations:
        Output<List<RuleGroupRuleStatementByteMatchStatementTextTransformationArgs>>? = null

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("puoryyrbcnqucvbf")
    public suspend fun fieldToMatch(`value`: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value The area within the portion of a web request that you want AWS WAF to search for `search_string`. Valid values include the following: `EXACTLY`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CONTAINS_WORD`. See the AWS [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchStatement.html) for more information.
     */
    @JvmName("rjgarixcnusrbexo")
    public suspend fun positionalConstraint(`value`: Output<String>) {
        this.positionalConstraint = value
    }

    /**
     * @param value A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in `field_to_match`. The maximum length of the value is 50 bytes.
     */
    @JvmName("cqoggsfmlfdmgaxa")
    public suspend fun searchString(`value`: Output<String>) {
        this.searchString = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("bgqxqjakjmlqlcsh")
    public suspend fun textTransformations(`value`: Output<List<RuleGroupRuleStatementByteMatchStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("nossdjkhvrpktjby")
    public suspend fun textTransformations(vararg values: Output<RuleGroupRuleStatementByteMatchStatementTextTransformationArgs>) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("yfpujlvckhcdlehy")
    public suspend fun textTransformations(values: List<Output<RuleGroupRuleStatementByteMatchStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("orndouopwncvkmwc")
    public suspend fun fieldToMatch(`value`: RuleGroupRuleStatementByteMatchStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("cjeslspshyoebxbq")
    public suspend fun fieldToMatch(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementByteMatchStatementFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value The area within the portion of a web request that you want AWS WAF to search for `search_string`. Valid values include the following: `EXACTLY`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CONTAINS_WORD`. See the AWS [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchStatement.html) for more information.
     */
    @JvmName("jggloilsukypcynf")
    public suspend fun positionalConstraint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.positionalConstraint = mapped
    }

    /**
     * @param value A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in `field_to_match`. The maximum length of the value is 50 bytes.
     */
    @JvmName("nymahyhnhfofskyv")
    public suspend fun searchString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.searchString = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("aswfeacxiqdwfyvy")
    public suspend fun textTransformations(`value`: List<RuleGroupRuleStatementByteMatchStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("mvxqhovsifgjhmjx")
    public suspend fun textTransformations(argument: List<suspend RuleGroupRuleStatementByteMatchStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementByteMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("vfpyssinjaceoybc")
    public suspend fun textTransformations(vararg argument: suspend RuleGroupRuleStatementByteMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementByteMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("kuppnbashvogmeog")
    public suspend fun textTransformations(argument: suspend RuleGroupRuleStatementByteMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementByteMatchStatementTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("rbnmbcurvfstosca")
    public suspend fun textTransformations(vararg values: RuleGroupRuleStatementByteMatchStatementTextTransformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): RuleGroupRuleStatementByteMatchStatementArgs =
        RuleGroupRuleStatementByteMatchStatementArgs(
            fieldToMatch = fieldToMatch,
            positionalConstraint = positionalConstraint ?: throw
                PulumiNullFieldException("positionalConstraint"),
            searchString = searchString ?: throw PulumiNullFieldException("searchString"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
