@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementByteMatchStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers.
 * @property cookies Inspect the cookies in the web request. See Cookies below for details.
 * @property headerOrders Inspect the request headers. See Header Order below for details.
 * @property headers Inspect the request headers. See Headers below for details.
 * @property ja3Fingerprint
 * @property jsonBody Inspect the request body as JSON. See JSON Body for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See Single Header below for details.
 * @property singleQueryArgument Inspect a single query argument. See Single Query Argument below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class RuleGroupRuleStatementByteMatchStatementFieldToMatchArgs(
    public val allQueryArguments: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null,
    public val body: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchBodyArgs>? = null,
    public val cookies: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchCookiesArgs>? =
        null,
    public val headerOrders: Output<List<RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgs>>? = null,
    public val headers: Output<List<RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchJa3FingerprintArgs>? = null,
    public val jsonBody: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchJsonBodyArgs>? =
        null,
    public val method: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchMethodArgs>? = null,
    public val queryString: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchQueryStringArgs>? = null,
    public val singleHeader: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchSingleHeaderArgs>? = null,
    public val singleQueryArgument: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null,
    public val uriPath: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchUriPathArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementByteMatchStatementFieldToMatchArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementByteMatchStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementByteMatchStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headerOrders(
                headerOrders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RuleGroupRuleStatementByteMatchStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementByteMatchStatementFieldToMatchArgsBuilder internal constructor() {
    private var allQueryArguments:
        Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null

    private var body: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchBodyArgs>? = null

    private var cookies: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchCookiesArgs>? =
        null

    private var headerOrders:
        Output<List<RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgs>>? = null

    private var headers: Output<List<RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgs>>? =
        null

    private var ja3Fingerprint:
        Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchJa3FingerprintArgs>? = null

    private var jsonBody: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchJsonBodyArgs>? =
        null

    private var method: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchMethodArgs>? = null

    private var queryString:
        Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchQueryStringArgs>? = null

    private var singleHeader:
        Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchSingleHeaderArgs>? = null

    private var singleQueryArgument:
        Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null

    private var uriPath: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchUriPathArgs>? =
        null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("purnrlyocxefwwtk")
    public suspend fun allQueryArguments(`value`: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("lhmehtmiokkjnrsn")
    public suspend fun body(`value`: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("lrlvwwchpguiqgul")
    public suspend fun cookies(`value`: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect the request headers. See Header Order below for details.
     */
    @JvmName("yabtnregeydbonkd")
    public suspend fun headerOrders(`value`: Output<List<RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = value
    }

    @JvmName("bmvoleidbgvyxyuh")
    public suspend fun headerOrders(vararg values: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgs>) {
        this.headerOrders = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See Header Order below for details.
     */
    @JvmName("lhtpiluarrhcssmk")
    public suspend fun headerOrders(values: List<Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = Output.all(values)
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("xhgfyfinsxhktgaw")
    public suspend fun headers(`value`: Output<List<RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("sbteprkpkgohjtxu")
    public suspend fun headers(vararg values: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("jynkjmqonscpjvek")
    public suspend fun headers(values: List<Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("htdgbpkhknjkwryu")
    public suspend fun ja3Fingerprint(`value`: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("lrhamepwgbjrnljg")
    public suspend fun jsonBody(`value`: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("gnveqwuiobcjqlhj")
    public suspend fun method(`value`: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("xluqfvpgtfixkkdh")
    public suspend fun queryString(`value`: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("irvptdstgaloobqe")
    public suspend fun singleHeader(`value`: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("jyxvgmrhgyhftogx")
    public suspend fun singleQueryArgument(`value`: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("yvsnfuglfrhcbhig")
    public suspend fun uriPath(`value`: Output<RuleGroupRuleStatementByteMatchStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("foasccueaomhpjmd")
    public suspend fun allQueryArguments(`value`: RuleGroupRuleStatementByteMatchStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("lasjsykucoyryxcy")
    public suspend fun allQueryArguments(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementByteMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("bedqaqdawjmsncxf")
    public suspend fun body(`value`: RuleGroupRuleStatementByteMatchStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("vjieqnxhwexodbck")
    public suspend fun body(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementByteMatchStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("ueofhlfsqfegwtlv")
    public suspend fun cookies(`value`: RuleGroupRuleStatementByteMatchStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("hwvtphgtuwogqqfs")
    public suspend fun cookies(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementByteMatchStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect the request headers. See Header Order below for details.
     */
    @JvmName("yrvesrkchflbplfs")
    public suspend fun headerOrders(`value`: List<RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect the request headers. See Header Order below for details.
     */
    @JvmName("vyguxdysdsqeprai")
    public suspend fun headerOrders(argument: List<suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect the request headers. See Header Order below for details.
     */
    @JvmName("bkirpklyrpocyqkk")
    public suspend fun headerOrders(vararg argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect the request headers. See Header Order below for details.
     */
    @JvmName("huakamkfrpuegwwk")
    public suspend fun headerOrders(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param values Inspect the request headers. See Header Order below for details.
     */
    @JvmName("uhmauiyehfasaopr")
    public suspend fun headerOrders(vararg values: RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderOrderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("iviawvvcnhlpoqdp")
    public suspend fun headers(`value`: List<RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("wpntwpufdtjmowya")
    public suspend fun headers(argument: List<suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("rjodmelpuilywwyg")
    public suspend fun headers(vararg argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("gquyrhwoxemnrarw")
    public suspend fun headers(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("yslijeaacvnyguwj")
    public suspend fun headers(vararg values: RuleGroupRuleStatementByteMatchStatementFieldToMatchHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value
     */
    @JvmName("nyognseuqndtqlyi")
    public suspend fun ja3Fingerprint(`value`: RuleGroupRuleStatementByteMatchStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lpoflxvjjvojbkph")
    public suspend fun ja3Fingerprint(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementByteMatchStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("vwjawwnxowepknyn")
    public suspend fun jsonBody(`value`: RuleGroupRuleStatementByteMatchStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("jdhpsjvvranfbads")
    public suspend fun jsonBody(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementByteMatchStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("keadqjghelsqbfwf")
    public suspend fun method(`value`: RuleGroupRuleStatementByteMatchStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("jgumeupbnrwuwamj")
    public suspend fun method(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementByteMatchStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("iqmflfdhrreexsio")
    public suspend fun queryString(`value`: RuleGroupRuleStatementByteMatchStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("acoopacciswdmpho")
    public suspend fun queryString(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementByteMatchStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("txoekjsynuogwhml")
    public suspend fun singleHeader(`value`: RuleGroupRuleStatementByteMatchStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See Single Header below for details.
     */
    @JvmName("dfwismcsrqxuxchb")
    public suspend fun singleHeader(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementByteMatchStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("pjhcragwhnogupnk")
    public suspend fun singleQueryArgument(`value`: RuleGroupRuleStatementByteMatchStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("ssufgepcxmqqckmk")
    public suspend fun singleQueryArgument(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementByteMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("pyundktqktdlndpn")
    public suspend fun uriPath(`value`: RuleGroupRuleStatementByteMatchStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("ojsogukmuquabcuo")
    public suspend fun uriPath(argument: suspend RuleGroupRuleStatementByteMatchStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementByteMatchStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): RuleGroupRuleStatementByteMatchStatementFieldToMatchArgs =
        RuleGroupRuleStatementByteMatchStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headerOrders = headerOrders,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
