@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See Text Transformation above for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgs(
    public val textTransformations: Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgs.builder()
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgsBuilder internal constructor() {
    private var textTransformations:
        Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs>>? =
        null

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See Text Transformation above for details.
     */
    @JvmName("rxkhydfsjuwojwwq")
    public suspend fun textTransformations(`value`: Output<List<RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("paydnldpxfbcqlys")
    public suspend fun textTransformations(vararg values: Output<RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs>) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See Text Transformation above for details.
     */
    @JvmName("nuabckbqyoegonkb")
    public suspend fun textTransformations(values: List<Output<RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See Text Transformation above for details.
     */
    @JvmName("rlivjxsosefgrpdh")
    public suspend fun textTransformations(`value`: List<RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See Text Transformation above for details.
     */
    @JvmName("jkvpkeegtkqcypap")
    public suspend fun textTransformations(argument: List<suspend RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See Text Transformation above for details.
     */
    @JvmName("avnvgcxmrorgkfkw")
    public suspend fun textTransformations(vararg argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See Text Transformation above for details.
     */
    @JvmName("ijqvaidnxxaiaibx")
    public suspend fun textTransformations(argument: suspend RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See Text Transformation above for details.
     */
    @JvmName("rxnlvkuuvnludtwa")
    public suspend fun textTransformations(vararg values: RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgs =
        RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathArgs(
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
