@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fallbackBehavior The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
 * @property headerName The name of the HTTP header to use for the IP address.
 */
public data class RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgs(
    public val fallbackBehavior: Output<String>,
    public val headerName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgs.builder()
            .fallbackBehavior(fallbackBehavior.applyValue({ args0 -> args0 }))
            .headerName(headerName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgsBuilder internal constructor() {
    private var fallbackBehavior: Output<String>? = null

    private var headerName: Output<String>? = null

    /**
     * @param value The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
     */
    @JvmName("uipjycitsupnqcdq")
    public suspend fun fallbackBehavior(`value`: Output<String>) {
        this.fallbackBehavior = value
    }

    /**
     * @param value The name of the HTTP header to use for the IP address.
     */
    @JvmName("njyxicgiqvgjmvfx")
    public suspend fun headerName(`value`: Output<String>) {
        this.headerName = value
    }

    /**
     * @param value The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
     */
    @JvmName("ucdstxiubmrpkwbe")
    public suspend fun fallbackBehavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fallbackBehavior = mapped
    }

    /**
     * @param value The name of the HTTP header to use for the IP address.
     */
    @JvmName("oskmoruvwbvrlxvl")
    public suspend fun headerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerName = mapped
    }

    internal fun build(): RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgs =
        RuleGroupRuleStatementRateBasedStatementForwardedIpConfigArgs(
            fallbackBehavior = fallbackBehavior ?: throw PulumiNullFieldException("fallbackBehavior"),
            headerName = headerName ?: throw PulumiNullFieldException("headerName"),
        )
}
