@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property statements The statements to combine.
 */
public data class RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs(
    public val statements: Output<List<RuleGroupRuleStatementArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs.builder()
            .statements(
                statements.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgsBuilder
internal constructor() {
    private var statements: Output<List<RuleGroupRuleStatementArgs>>? = null

    /**
     * @param value The statements to combine.
     */
    @JvmName("mkftduhthndoysbg")
    public suspend fun statements(`value`: Output<List<RuleGroupRuleStatementArgs>>) {
        this.statements = value
    }

    @JvmName("juhfhchsrjckprtv")
    public suspend fun statements(vararg values: Output<RuleGroupRuleStatementArgs>) {
        this.statements = Output.all(values.asList())
    }

    /**
     * @param values The statements to combine.
     */
    @JvmName("yabnxeoiosgglqpk")
    public suspend fun statements(values: List<Output<RuleGroupRuleStatementArgs>>) {
        this.statements = Output.all(values)
    }

    /**
     * @param value The statements to combine.
     */
    @JvmName("fmocxfgebgvicrje")
    public suspend fun statements(`value`: List<RuleGroupRuleStatementArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("vbuvajaccqjlpccd")
    public suspend fun statements(argument: List<suspend RuleGroupRuleStatementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("jtueyfgfheihrfju")
    public suspend fun statements(vararg argument: suspend RuleGroupRuleStatementArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("ekjevnvfjrwdfyws")
    public suspend fun statements(argument: suspend RuleGroupRuleStatementArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleGroupRuleStatementArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param values The statements to combine.
     */
    @JvmName("wldefhvghshfmpey")
    public suspend fun statements(vararg values: RuleGroupRuleStatementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    internal fun build(): RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs =
        RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs(
            statements = statements ?: throw PulumiNullFieldException("statements"),
        )
}
