@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property andStatement A logical rule statement used to combine other rule statements with AND logic. See AND Statement below for details.
 * @property byteMatchStatement A rule statement that defines a string match search for AWS WAF to apply to web requests. See Byte Match Statement below for details.
 * @property geoMatchStatement A rule statement used to identify web requests based on country of origin. See GEO Match Statement below for details.
 * @property ipSetReferenceStatement A rule statement used to detect web requests coming from particular IP addresses or address ranges. See IP Set Reference Statement below for details.
 * @property labelMatchStatement A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See Label Match Statement below for details.
 * @property notStatement A logical rule statement used to negate the results of another rule statement. See NOT Statement below for details.
 * @property orStatement A logical rule statement used to combine other rule statements with OR logic. See OR Statement below for details.
 * @property regexMatchStatement A rule statement used to search web request components for a match against a single regular expression. See Regex Match Statement below for details.
 * @property regexPatternSetReferenceStatement A rule statement used to search web request components for matches with regular expressions. See Regex Pattern Set Reference Statement below for details.
 * @property sizeConstraintStatement A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See Size Constraint Statement below for more details.
 * @property sqliMatchStatement An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See SQL Injection Match Statement below for details.
 * @property xssMatchStatement A rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See XSS Match Statement below for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgs(
    public val andStatement: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs>? = null,
    public val byteMatchStatement: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs>? =
        null,
    public val geoMatchStatement: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs>? =
        null,
    public val ipSetReferenceStatement: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs>? =
        null,
    public val labelMatchStatement: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatementArgs>? =
        null,
    public val notStatement: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementNotStatementArgs>? = null,
    public val orStatement: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs>? = null,
    public val regexMatchStatement: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs>? =
        null,
    public val regexPatternSetReferenceStatement: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs>? =
        null,
    public val sizeConstraintStatement: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementArgs>? =
        null,
    public val sqliMatchStatement: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs>? =
        null,
    public val xssMatchStatement: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementXssMatchStatementArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgs.builder()
            .andStatement(andStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .byteMatchStatement(
                byteMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .geoMatchStatement(geoMatchStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipSetReferenceStatement(
                ipSetReferenceStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .labelMatchStatement(
                labelMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .notStatement(notStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .orStatement(orStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regexMatchStatement(
                regexMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .regexPatternSetReferenceStatement(
                regexPatternSetReferenceStatement?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sizeConstraintStatement(
                sizeConstraintStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sqliMatchStatement(
                sqliMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .xssMatchStatement(
                xssMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgsBuilder internal constructor() {
    private var andStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs>? = null

    private var byteMatchStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs>? =
        null

    private var geoMatchStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs>? =
        null

    private var ipSetReferenceStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs>? =
        null

    private var labelMatchStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatementArgs>? =
        null

    private var notStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementNotStatementArgs>? = null

    private var orStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs>? = null

    private var regexMatchStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs>? =
        null

    private var regexPatternSetReferenceStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs>? =
        null

    private var sizeConstraintStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementArgs>? =
        null

    private var sqliMatchStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs>? =
        null

    private var xssMatchStatement:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementXssMatchStatementArgs>? =
        null

    /**
     * @param value A logical rule statement used to combine other rule statements with AND logic. See AND Statement below for details.
     */
    @JvmName("tnypbxrhwodxnqfg")
    public suspend fun andStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs>) {
        this.andStatement = value
    }

    /**
     * @param value A rule statement that defines a string match search for AWS WAF to apply to web requests. See Byte Match Statement below for details.
     */
    @JvmName("mvshqsxsjwatcksi")
    public suspend fun byteMatchStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs>) {
        this.byteMatchStatement = value
    }

    /**
     * @param value A rule statement used to identify web requests based on country of origin. See GEO Match Statement below for details.
     */
    @JvmName("lbhxkqqopdhrtjtn")
    public suspend fun geoMatchStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs>) {
        this.geoMatchStatement = value
    }

    /**
     * @param value A rule statement used to detect web requests coming from particular IP addresses or address ranges. See IP Set Reference Statement below for details.
     */
    @JvmName("cnxhklpqwklrqmbi")
    public suspend fun ipSetReferenceStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs>) {
        this.ipSetReferenceStatement = value
    }

    /**
     * @param value A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See Label Match Statement below for details.
     */
    @JvmName("acwswtmttfnibpbl")
    public suspend fun labelMatchStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatementArgs>) {
        this.labelMatchStatement = value
    }

    /**
     * @param value A logical rule statement used to negate the results of another rule statement. See NOT Statement below for details.
     */
    @JvmName("fxaukadxviyloxbd")
    public suspend fun notStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementNotStatementArgs>) {
        this.notStatement = value
    }

    /**
     * @param value A logical rule statement used to combine other rule statements with OR logic. See OR Statement below for details.
     */
    @JvmName("saxktcewbpkcrprm")
    public suspend fun orStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs>) {
        this.orStatement = value
    }

    /**
     * @param value A rule statement used to search web request components for a match against a single regular expression. See Regex Match Statement below for details.
     */
    @JvmName("fmtacvufwqxnxyqo")
    public suspend fun regexMatchStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs>) {
        this.regexMatchStatement = value
    }

    /**
     * @param value A rule statement used to search web request components for matches with regular expressions. See Regex Pattern Set Reference Statement below for details.
     */
    @JvmName("iyglwthjwbfocluv")
    public suspend fun regexPatternSetReferenceStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs>) {
        this.regexPatternSetReferenceStatement = value
    }

    /**
     * @param value A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See Size Constraint Statement below for more details.
     */
    @JvmName("ngbcyytlymavojtm")
    public suspend fun sizeConstraintStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementArgs>) {
        this.sizeConstraintStatement = value
    }

    /**
     * @param value An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See SQL Injection Match Statement below for details.
     */
    @JvmName("nqbvfdpeubkriysw")
    public suspend fun sqliMatchStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs>) {
        this.sqliMatchStatement = value
    }

    /**
     * @param value A rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See XSS Match Statement below for details.
     */
    @JvmName("ghuaugqfwyxbwirl")
    public suspend fun xssMatchStatement(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementXssMatchStatementArgs>) {
        this.xssMatchStatement = value
    }

    /**
     * @param value A logical rule statement used to combine other rule statements with AND logic. See AND Statement below for details.
     */
    @JvmName("ietlqcbemskbppuc")
    public suspend fun andStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.andStatement = mapped
    }

    /**
     * @param argument A logical rule statement used to combine other rule statements with AND logic. See AND Statement below for details.
     */
    @JvmName("kntkxakxlwhwmjjd")
    public suspend fun andStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementAndStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.andStatement = mapped
    }

    /**
     * @param value A rule statement that defines a string match search for AWS WAF to apply to web requests. See Byte Match Statement below for details.
     */
    @JvmName("wfgpdyrehmlpvhhe")
    public suspend fun byteMatchStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.byteMatchStatement = mapped
    }

    /**
     * @param argument A rule statement that defines a string match search for AWS WAF to apply to web requests. See Byte Match Statement below for details.
     */
    @JvmName("dbtystirmpiauavw")
    public suspend fun byteMatchStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.byteMatchStatement = mapped
    }

    /**
     * @param value A rule statement used to identify web requests based on country of origin. See GEO Match Statement below for details.
     */
    @JvmName("lssbfbwmamtqbrgt")
    public suspend fun geoMatchStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoMatchStatement = mapped
    }

    /**
     * @param argument A rule statement used to identify web requests based on country of origin. See GEO Match Statement below for details.
     */
    @JvmName("wmkjswacesdhhxyd")
    public suspend fun geoMatchStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.geoMatchStatement = mapped
    }

    /**
     * @param value A rule statement used to detect web requests coming from particular IP addresses or address ranges. See IP Set Reference Statement below for details.
     */
    @JvmName("rrqgmgfrjevifubt")
    public suspend fun ipSetReferenceStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSetReferenceStatement = mapped
    }

    /**
     * @param argument A rule statement used to detect web requests coming from particular IP addresses or address ranges. See IP Set Reference Statement below for details.
     */
    @JvmName("sjsdhhybnhpyeaxu")
    public suspend fun ipSetReferenceStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ipSetReferenceStatement = mapped
    }

    /**
     * @param value A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See Label Match Statement below for details.
     */
    @JvmName("figsleydcsoelbud")
    public suspend fun labelMatchStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelMatchStatement = mapped
    }

    /**
     * @param argument A rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See Label Match Statement below for details.
     */
    @JvmName("ycvnycuacehqovlv")
    public suspend fun labelMatchStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.labelMatchStatement = mapped
    }

    /**
     * @param value A logical rule statement used to negate the results of another rule statement. See NOT Statement below for details.
     */
    @JvmName("ggbwmeoifkdiryly")
    public suspend fun notStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementNotStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notStatement = mapped
    }

    /**
     * @param argument A logical rule statement used to negate the results of another rule statement. See NOT Statement below for details.
     */
    @JvmName("xxiieqvnyesymhum")
    public suspend fun notStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementNotStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementNotStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.notStatement = mapped
    }

    /**
     * @param value A logical rule statement used to combine other rule statements with OR logic. See OR Statement below for details.
     */
    @JvmName("masahkayhuohuqwc")
    public suspend fun orStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orStatement = mapped
    }

    /**
     * @param argument A logical rule statement used to combine other rule statements with OR logic. See OR Statement below for details.
     */
    @JvmName("uuvqvckrtydhgwni")
    public suspend fun orStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.orStatement = mapped
    }

    /**
     * @param value A rule statement used to search web request components for a match against a single regular expression. See Regex Match Statement below for details.
     */
    @JvmName("lkajbatbxmfhmgdm")
    public suspend fun regexMatchStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexMatchStatement = mapped
    }

    /**
     * @param argument A rule statement used to search web request components for a match against a single regular expression. See Regex Match Statement below for details.
     */
    @JvmName("rncisgudwlkswbmw")
    public suspend fun regexMatchStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.regexMatchStatement = mapped
    }

    /**
     * @param value A rule statement used to search web request components for matches with regular expressions. See Regex Pattern Set Reference Statement below for details.
     */
    @JvmName("xlwttyepdcyckxtg")
    public suspend fun regexPatternSetReferenceStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexPatternSetReferenceStatement = mapped
    }

    /**
     * @param argument A rule statement used to search web request components for matches with regular expressions. See Regex Pattern Set Reference Statement below for details.
     */
    @JvmName("ojbmccvkxiljnlpa")
    public suspend fun regexPatternSetReferenceStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.regexPatternSetReferenceStatement = mapped
    }

    /**
     * @param value A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See Size Constraint Statement below for more details.
     */
    @JvmName("yskfpniofduqmaba")
    public suspend fun sizeConstraintStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeConstraintStatement = mapped
    }

    /**
     * @param argument A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See Size Constraint Statement below for more details.
     */
    @JvmName("pdtoomduglgukauk")
    public suspend fun sizeConstraintStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sizeConstraintStatement = mapped
    }

    /**
     * @param value An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See SQL Injection Match Statement below for details.
     */
    @JvmName("wtufwrvdnyxvrbtw")
    public suspend fun sqliMatchStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqliMatchStatement = mapped
    }

    /**
     * @param argument An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See SQL Injection Match Statement below for details.
     */
    @JvmName("vcbhdrcppemgsani")
    public suspend fun sqliMatchStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sqliMatchStatement = mapped
    }

    /**
     * @param value A rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See XSS Match Statement below for details.
     */
    @JvmName("qifxmgwkxmffrxmj")
    public suspend fun xssMatchStatement(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementXssMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xssMatchStatement = mapped
    }

    /**
     * @param argument A rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See XSS Match Statement below for details.
     */
    @JvmName("xrxjydaljlroielk")
    public suspend fun xssMatchStatement(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementXssMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementXssMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.xssMatchStatement = mapped
    }

    internal fun build(): RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgs =
        RuleGroupRuleStatementRateBasedStatementScopeDownStatementArgs(
            andStatement = andStatement,
            byteMatchStatement = byteMatchStatement,
            geoMatchStatement = geoMatchStatement,
            ipSetReferenceStatement = ipSetReferenceStatement,
            labelMatchStatement = labelMatchStatement,
            notStatement = notStatement,
            orStatement = orStatement,
            regexMatchStatement = regexMatchStatement,
            regexPatternSetReferenceStatement = regexPatternSetReferenceStatement,
            sizeConstraintStatement = sizeConstraintStatement,
            sqliMatchStatement = sqliMatchStatement,
            xssMatchStatement = xssMatchStatement,
        )
}
