@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the IP Set that this statement references.
 * @property ipSetForwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See IPSet Forwarded IP Config below for more details.
 */
public data class
RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs(
    public val arn: Output<String>,
    public val ipSetForwardedIpConfig: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .ipSetForwardedIpConfig(
                ipSetForwardedIpConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs].
 */
@PulumiTagMarker
public class
RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgsBuilder
internal constructor() {
    private var arn: Output<String>? = null

    private var ipSetForwardedIpConfig:
        Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs>? =
        null

    /**
     * @param value The Amazon Resource Name (ARN) of the IP Set that this statement references.
     */
    @JvmName("efekcikeslbvkbdl")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See IPSet Forwarded IP Config below for more details.
     */
    @JvmName("blpyfogipjbbbcgt")
    public suspend fun ipSetForwardedIpConfig(`value`: Output<RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs>) {
        this.ipSetForwardedIpConfig = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IP Set that this statement references.
     */
    @JvmName("nbtrmoulbjihepww")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See IPSet Forwarded IP Config below for more details.
     */
    @JvmName("corfhjjwmiwpxmcq")
    public suspend fun ipSetForwardedIpConfig(`value`: RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSetForwardedIpConfig = mapped
    }

    /**
     * @param argument The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See IPSet Forwarded IP Config below for more details.
     */
    @JvmName("owakfyqriqbdnndy")
    public suspend fun ipSetForwardedIpConfig(argument: suspend RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ipSetForwardedIpConfig = mapped
    }

    internal fun build(): RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs =
        RuleGroupRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatementArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            ipSetForwardedIpConfig = ipSetForwardedIpConfig,
        )
}
