@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property statements The statements to combine.
 */
public data class RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs(
    public val statements: Output<List<RuleGroupRuleStatementArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs.builder()
            .statements(
                statements.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgsBuilder
internal constructor() {
    private var statements: Output<List<RuleGroupRuleStatementArgs>>? = null

    /**
     * @param value The statements to combine.
     */
    @JvmName("wtjegumseejrkgya")
    public suspend fun statements(`value`: Output<List<RuleGroupRuleStatementArgs>>) {
        this.statements = value
    }

    @JvmName("gjohsfbcxehgyrrs")
    public suspend fun statements(vararg values: Output<RuleGroupRuleStatementArgs>) {
        this.statements = Output.all(values.asList())
    }

    /**
     * @param values The statements to combine.
     */
    @JvmName("biseltnlkliixabg")
    public suspend fun statements(values: List<Output<RuleGroupRuleStatementArgs>>) {
        this.statements = Output.all(values)
    }

    /**
     * @param value The statements to combine.
     */
    @JvmName("pmgakdrwrbisrgxm")
    public suspend fun statements(`value`: List<RuleGroupRuleStatementArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("mvbiyhhtdvrmthlw")
    public suspend fun statements(argument: List<suspend RuleGroupRuleStatementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("nvxebrtifxdiseit")
    public suspend fun statements(vararg argument: suspend RuleGroupRuleStatementArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("asxiakeshijeymkp")
    public suspend fun statements(argument: suspend RuleGroupRuleStatementArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleGroupRuleStatementArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param values The statements to combine.
     */
    @JvmName("gvixjdvsvpdtunea")
    public suspend fun statements(vararg values: RuleGroupRuleStatementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    internal fun build(): RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs =
        RuleGroupRuleStatementRateBasedStatementScopeDownStatementOrStatementArgs(
            statements = statements ?: throw PulumiNullFieldException("statements"),
        )
}
