@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
 * @property regexString The string representing the regular expression. **Note:** The fixed quota for the maximum number of characters in each regex pattern is 200, which can't be changed. See [AWS WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) for details.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementRegexMatchStatementArgs(
    public val fieldToMatch: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgs>? =
        null,
    public val regexString: Output<String>,
    public val textTransformations: Output<List<RuleGroupRuleStatementRegexMatchStatementTextTransformationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexMatchStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexMatchStatementArgs.builder()
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regexString(regexString.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementRegexMatchStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRegexMatchStatementArgsBuilder internal constructor() {
    private var fieldToMatch: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgs>? =
        null

    private var regexString: Output<String>? = null

    private var textTransformations:
        Output<List<RuleGroupRuleStatementRegexMatchStatementTextTransformationArgs>>? = null

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("fkynibbkcdpobmxy")
    public suspend fun fieldToMatch(`value`: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value The string representing the regular expression. **Note:** The fixed quota for the maximum number of characters in each regex pattern is 200, which can't be changed. See [AWS WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) for details.
     */
    @JvmName("xvlddcjmirbmxobf")
    public suspend fun regexString(`value`: Output<String>) {
        this.regexString = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("kenhbdbiaovghpjh")
    public suspend fun textTransformations(`value`: Output<List<RuleGroupRuleStatementRegexMatchStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("brrtingfvlfwfklq")
    public suspend fun textTransformations(vararg values: Output<RuleGroupRuleStatementRegexMatchStatementTextTransformationArgs>) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("anwhioogjjesxptl")
    public suspend fun textTransformations(values: List<Output<RuleGroupRuleStatementRegexMatchStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("olpjsneqbbimjxsi")
    public suspend fun fieldToMatch(`value`: RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("qjwvpjwthyvptsnf")
    public suspend fun fieldToMatch(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value The string representing the regular expression. **Note:** The fixed quota for the maximum number of characters in each regex pattern is 200, which can't be changed. See [AWS WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) for details.
     */
    @JvmName("vtrbgannsqnuiaco")
    public suspend fun regexString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regexString = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("bsjasysimxrfumsy")
    public suspend fun textTransformations(`value`: List<RuleGroupRuleStatementRegexMatchStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("lbetjspyjhpopvwt")
    public suspend fun textTransformations(argument: List<suspend RuleGroupRuleStatementRegexMatchStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRegexMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("nsnodldwftrkymav")
    public suspend fun textTransformations(vararg argument: suspend RuleGroupRuleStatementRegexMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRegexMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("hwvrsylllgrhalod")
    public suspend fun textTransformations(argument: suspend RuleGroupRuleStatementRegexMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementRegexMatchStatementTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("djvrxrrggoygikbo")
    public suspend fun textTransformations(vararg values: RuleGroupRuleStatementRegexMatchStatementTextTransformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): RuleGroupRuleStatementRegexMatchStatementArgs =
        RuleGroupRuleStatementRegexMatchStatementArgs(
            fieldToMatch = fieldToMatch,
            regexString = regexString ?: throw PulumiNullFieldException("regexString"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
