@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers.
 * @property cookies Inspect the cookies in the web request. See Cookies below for details.
 * @property headerOrders Inspect the request headers. See Header Order below for details.
 * @property headers Inspect the request headers. See Headers below for details.
 * @property ja3Fingerprint
 * @property jsonBody Inspect the request body as JSON. See JSON Body for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See Single Header below for details.
 * @property singleQueryArgument Inspect a single query argument. See Single Query Argument below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgs(
    public val allQueryArguments: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null,
    public val body: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchBodyArgs>? = null,
    public val cookies: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchCookiesArgs>? =
        null,
    public val headerOrders: Output<List<RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgs>>? = null,
    public val headers: Output<List<RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchJa3FingerprintArgs>? = null,
    public val jsonBody: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchJsonBodyArgs>? =
        null,
    public val method: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchMethodArgs>? =
        null,
    public val queryString: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchQueryStringArgs>? = null,
    public val singleHeader: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchSingleHeaderArgs>? = null,
    public val singleQueryArgument: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null,
    public val uriPath: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchUriPathArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headerOrders(
                headerOrders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgsBuilder internal constructor() {
    private var allQueryArguments:
        Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null

    private var body: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchBodyArgs>? = null

    private var cookies: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchCookiesArgs>? =
        null

    private var headerOrders:
        Output<List<RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgs>>? = null

    private var headers:
        Output<List<RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgs>>? = null

    private var ja3Fingerprint:
        Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchJa3FingerprintArgs>? = null

    private var jsonBody: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchJsonBodyArgs>? =
        null

    private var method: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchMethodArgs>? =
        null

    private var queryString:
        Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchQueryStringArgs>? = null

    private var singleHeader:
        Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchSingleHeaderArgs>? = null

    private var singleQueryArgument:
        Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null

    private var uriPath: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchUriPathArgs>? =
        null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("jigqgxkvmllbpiam")
    public suspend fun allQueryArguments(`value`: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("qqbnpoieumrhklrb")
    public suspend fun body(`value`: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("kwkrypjcujnysvrl")
    public suspend fun cookies(`value`: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect the request headers. See Header Order below for details.
     */
    @JvmName("xgxpcmikyloscyol")
    public suspend fun headerOrders(`value`: Output<List<RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = value
    }

    @JvmName("fldujbyntermtass")
    public suspend fun headerOrders(vararg values: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgs>) {
        this.headerOrders = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See Header Order below for details.
     */
    @JvmName("igixcnbwxxacigcf")
    public suspend fun headerOrders(values: List<Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = Output.all(values)
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("htubylspyawrgucd")
    public suspend fun headers(`value`: Output<List<RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("jjewcmuwwwjsmkif")
    public suspend fun headers(vararg values: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("bsigokmydtbnyend")
    public suspend fun headers(values: List<Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("seodlxfumwuefhpu")
    public suspend fun ja3Fingerprint(`value`: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("fodexoyetnqmgnks")
    public suspend fun jsonBody(`value`: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("tpuvsqjrebddgeka")
    public suspend fun method(`value`: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("xukwlwhafmlurdcn")
    public suspend fun queryString(`value`: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("ayakftjwvmfqjtad")
    public suspend fun singleHeader(`value`: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("cbelpgbkqdbfabcv")
    public suspend fun singleQueryArgument(`value`: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("cloounobgroufqyv")
    public suspend fun uriPath(`value`: Output<RuleGroupRuleStatementRegexMatchStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("rvsqgpsmycwivbkt")
    public suspend fun allQueryArguments(`value`: RuleGroupRuleStatementRegexMatchStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("nurbgrinmpxewahg")
    public suspend fun allQueryArguments(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("qpuyaxhdtebfkfbr")
    public suspend fun body(`value`: RuleGroupRuleStatementRegexMatchStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("cdidrmcoisrscdxn")
    public suspend fun body(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("vcoxkkuaybtuirag")
    public suspend fun cookies(`value`: RuleGroupRuleStatementRegexMatchStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("gflfxatsfedvirye")
    public suspend fun cookies(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect the request headers. See Header Order below for details.
     */
    @JvmName("cbokmxkliffbtosq")
    public suspend fun headerOrders(`value`: List<RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect the request headers. See Header Order below for details.
     */
    @JvmName("mmffyiollhddweak")
    public suspend fun headerOrders(argument: List<suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect the request headers. See Header Order below for details.
     */
    @JvmName("cgkpkjvvayagjbkq")
    public suspend fun headerOrders(vararg argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect the request headers. See Header Order below for details.
     */
    @JvmName("vewvuebgjoygjlqb")
    public suspend fun headerOrders(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param values Inspect the request headers. See Header Order below for details.
     */
    @JvmName("xjytoytcmvailgmm")
    public suspend fun headerOrders(vararg values: RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderOrderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("gnnrwpsxfvttiwvy")
    public suspend fun headers(`value`: List<RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("unbdowphngdugxcd")
    public suspend fun headers(argument: List<suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("tlsabewdwiutvwun")
    public suspend fun headers(vararg argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("gujshxlwwktvlqsw")
    public suspend fun headers(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("soumypfidtpumaue")
    public suspend fun headers(vararg values: RuleGroupRuleStatementRegexMatchStatementFieldToMatchHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value
     */
    @JvmName("utapyofecekgfvgk")
    public suspend fun ja3Fingerprint(`value`: RuleGroupRuleStatementRegexMatchStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ryuiyoemirlvlidf")
    public suspend fun ja3Fingerprint(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("skslbryimfxuxxsu")
    public suspend fun jsonBody(`value`: RuleGroupRuleStatementRegexMatchStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("urovcfhywyyhapyt")
    public suspend fun jsonBody(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("tvkugieffpyweeob")
    public suspend fun method(`value`: RuleGroupRuleStatementRegexMatchStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("qsebyjvmepfemiko")
    public suspend fun method(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("itsgocmhrjhhfkcv")
    public suspend fun queryString(`value`: RuleGroupRuleStatementRegexMatchStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("ejjrtbpwrubnrnvc")
    public suspend fun queryString(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("qxtxywtbxdwuykxx")
    public suspend fun singleHeader(`value`: RuleGroupRuleStatementRegexMatchStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See Single Header below for details.
     */
    @JvmName("erqhcecefbknhkwp")
    public suspend fun singleHeader(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("oanukykbyofeetpr")
    public suspend fun singleQueryArgument(`value`: RuleGroupRuleStatementRegexMatchStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("vndewsxkipjvbnfp")
    public suspend fun singleQueryArgument(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("enkjbooyimepmrsx")
    public suspend fun uriPath(`value`: RuleGroupRuleStatementRegexMatchStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("atttysmfeslctgwx")
    public suspend fun uriPath(argument: suspend RuleGroupRuleStatementRegexMatchStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementRegexMatchStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgs =
        RuleGroupRuleStatementRegexMatchStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headerOrders = headerOrders,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
