@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers.
 * @property cookies Inspect the cookies in the web request. See Cookies below for details.
 * @property headerOrders Inspect the request headers. See Header Order below for details.
 * @property headers Inspect the request headers. See Headers below for details.
 * @property ja3Fingerprint
 * @property jsonBody Inspect the request body as JSON. See JSON Body for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See Single Header below for details.
 * @property singleQueryArgument Inspect a single query argument. See Single Query Argument below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgs(
    public val allQueryArguments: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgs>? =
        null,
    public val body: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchBodyArgs>? =
        null,
    public val cookies: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchCookiesArgs>? =
        null,
    public val headerOrders: Output<List<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgs>>? =
        null,
    public val headers: Output<List<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs>>? = null,
    public val ja3Fingerprint: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgs>? = null,
    public val jsonBody: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchJsonBodyArgs>? = null,
    public val method: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchMethodArgs>? =
        null,
    public val queryString: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchQueryStringArgs>? = null,
    public val singleHeader: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs>? = null,
    public val singleQueryArgument: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgs>? =
        null,
    public val uriPath: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchUriPathArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headerOrders(
                headerOrders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgsBuilder internal constructor() {
    private var allQueryArguments:
        Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgs>? = null

    private var body: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchBodyArgs>? =
        null

    private var cookies: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchCookiesArgs>? =
        null

    private var headerOrders:
        Output<List<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgs>>? = null

    private var headers:
        Output<List<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs>>? = null

    private var ja3Fingerprint:
        Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgs>? = null

    private var jsonBody:
        Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchJsonBodyArgs>? = null

    private var method: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchMethodArgs>? =
        null

    private var queryString:
        Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchQueryStringArgs>? = null

    private var singleHeader:
        Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs>? = null

    private var singleQueryArgument:
        Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgs>? =
        null

    private var uriPath: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchUriPathArgs>? =
        null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("kwrfpkecshbihgmx")
    public suspend fun allQueryArguments(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("rnagpxayysjxxfbs")
    public suspend fun body(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("rpemraktmyeuatdr")
    public suspend fun cookies(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect the request headers. See Header Order below for details.
     */
    @JvmName("yvmxicphmnhmpdci")
    public suspend fun headerOrders(`value`: Output<List<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = value
    }

    @JvmName("xoslwjxkyhkenscg")
    public suspend fun headerOrders(vararg values: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgs>) {
        this.headerOrders = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See Header Order below for details.
     */
    @JvmName("ogwbsaodjqpnwogj")
    public suspend fun headerOrders(values: List<Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = Output.all(values)
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("dbaktsvghjkxygub")
    public suspend fun headers(`value`: Output<List<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("hydchqfnlridweup")
    public suspend fun headers(vararg values: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("dcqpqduwuhtmtxdo")
    public suspend fun headers(values: List<Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("pjxwaqtiwiwyenbn")
    public suspend fun ja3Fingerprint(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("qwxfoleoexbmicyq")
    public suspend fun jsonBody(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("ckpfykwobwxbixcv")
    public suspend fun method(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("jxghppeyesbbqvcg")
    public suspend fun queryString(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("hoprausrxtsxvuqs")
    public suspend fun singleHeader(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("iqdcwwwrpynlrumx")
    public suspend fun singleQueryArgument(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("ekovqdqnjfiuhsxs")
    public suspend fun uriPath(`value`: Output<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("edevefyuwuneqrst")
    public suspend fun allQueryArguments(`value`: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("ifmdotbdokwbjjmg")
    public suspend fun allQueryArguments(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("byiqnyujgahbrsyo")
    public suspend fun body(`value`: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("akwrnovjqhqnrage")
    public suspend fun body(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("yjitefteksqlixie")
    public suspend fun cookies(`value`: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("syrroqitdbdsujbf")
    public suspend fun cookies(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect the request headers. See Header Order below for details.
     */
    @JvmName("tjowdmdlnwibyeur")
    public suspend fun headerOrders(`value`: List<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect the request headers. See Header Order below for details.
     */
    @JvmName("krbbidqojgokgnhs")
    public suspend fun headerOrders(argument: List<suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect the request headers. See Header Order below for details.
     */
    @JvmName("rgemrbjcwewjxumh")
    public suspend fun headerOrders(vararg argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect the request headers. See Header Order below for details.
     */
    @JvmName("fjxmusxenfsvsojm")
    public suspend fun headerOrders(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param values Inspect the request headers. See Header Order below for details.
     */
    @JvmName("qhvwiujefivsonlp")
    public suspend fun headerOrders(vararg values: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderOrderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("bhiuobkcagxvrfvp")
    public suspend fun headers(`value`: List<RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("elqrqiocvewegmmg")
    public suspend fun headers(argument: List<suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("rdfvnvwphgecardq")
    public suspend fun headers(vararg argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("ndkjyehgucmrobux")
    public suspend fun headers(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("jbflfpslwwwsgxok")
    public suspend fun headers(vararg values: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value
     */
    @JvmName("bghcxwjttpmjtyrb")
    public suspend fun ja3Fingerprint(`value`: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument
     */
    @JvmName("guqkqyxvhsydjuuh")
    public suspend fun ja3Fingerprint(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("jbcymvewtaelqkco")
    public suspend fun jsonBody(`value`: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("yhjltdrfsgcegbqo")
    public suspend fun jsonBody(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("vitecldpybvlwyrg")
    public suspend fun method(`value`: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("kfjlnbhajuedmgys")
    public suspend fun method(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("okjkcfblwdwaxwie")
    public suspend fun queryString(`value`: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("ycsihuvjfqmbgxec")
    public suspend fun queryString(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("opnewejqphwfcmap")
    public suspend fun singleHeader(`value`: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See Single Header below for details.
     */
    @JvmName("uvxhcxerqiahgjjk")
    public suspend fun singleHeader(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("dskrstohlmdvmcvu")
    public suspend fun singleQueryArgument(`value`: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("ptqvttceutpemkee")
    public suspend fun singleQueryArgument(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("omfyfrmwkqdbqlet")
    public suspend fun uriPath(`value`: RuleGroupRuleStatementSizeConstraintStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("ydsuoyqdvswiugfh")
    public suspend fun uriPath(argument: suspend RuleGroupRuleStatementSizeConstraintStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSizeConstraintStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgs =
        RuleGroupRuleStatementSizeConstraintStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headerOrders = headerOrders,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
