@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSqliMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
 * @property sensitivityLevel Sensitivity that you want AWS WAF to use to inspect for SQL injection attacks. Valid values include: `LOW`, `HIGH`.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementSqliMatchStatementArgs(
    public val fieldToMatch: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgs>? = null,
    public val sensitivityLevel: Output<String>? = null,
    public val textTransformations: Output<List<RuleGroupRuleStatementSqliMatchStatementTextTransformationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSqliMatchStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSqliMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSqliMatchStatementArgs.builder()
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sensitivityLevel(sensitivityLevel?.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementSqliMatchStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementSqliMatchStatementArgsBuilder internal constructor() {
    private var fieldToMatch: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgs>? = null

    private var sensitivityLevel: Output<String>? = null

    private var textTransformations:
        Output<List<RuleGroupRuleStatementSqliMatchStatementTextTransformationArgs>>? = null

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("rikxyqhwcuyjdcvj")
    public suspend fun fieldToMatch(`value`: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Sensitivity that you want AWS WAF to use to inspect for SQL injection attacks. Valid values include: `LOW`, `HIGH`.
     */
    @JvmName("esnaceqpogbjuhpd")
    public suspend fun sensitivityLevel(`value`: Output<String>) {
        this.sensitivityLevel = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("pvpghcyerqxrpgkg")
    public suspend fun textTransformations(`value`: Output<List<RuleGroupRuleStatementSqliMatchStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("bgbtjopsyboswmss")
    public suspend fun textTransformations(vararg values: Output<RuleGroupRuleStatementSqliMatchStatementTextTransformationArgs>) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("ffxoculorfymqfab")
    public suspend fun textTransformations(values: List<Output<RuleGroupRuleStatementSqliMatchStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("jllqfghsvetxtcon")
    public suspend fun fieldToMatch(`value`: RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("fdyhybpxxslnypot")
    public suspend fun fieldToMatch(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Sensitivity that you want AWS WAF to use to inspect for SQL injection attacks. Valid values include: `LOW`, `HIGH`.
     */
    @JvmName("wbqwhrainyqsuisi")
    public suspend fun sensitivityLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sensitivityLevel = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("wqvpdtuscsskeojd")
    public suspend fun textTransformations(`value`: List<RuleGroupRuleStatementSqliMatchStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("wxhntdoepwbtrpbl")
    public suspend fun textTransformations(argument: List<suspend RuleGroupRuleStatementSqliMatchStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementSqliMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("svtnnhueeobcxwmn")
    public suspend fun textTransformations(vararg argument: suspend RuleGroupRuleStatementSqliMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementSqliMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("cyvdqwaaudjusilq")
    public suspend fun textTransformations(argument: suspend RuleGroupRuleStatementSqliMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementSqliMatchStatementTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("ycadbflwglxqxmmi")
    public suspend fun textTransformations(vararg values: RuleGroupRuleStatementSqliMatchStatementTextTransformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): RuleGroupRuleStatementSqliMatchStatementArgs =
        RuleGroupRuleStatementSqliMatchStatementArgs(
            fieldToMatch = fieldToMatch,
            sensitivityLevel = sensitivityLevel,
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
