@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers.
 * @property cookies Inspect the cookies in the web request. See Cookies below for details.
 * @property headerOrders Inspect the request headers. See Header Order below for details.
 * @property headers Inspect the request headers. See Headers below for details.
 * @property ja3Fingerprint
 * @property jsonBody Inspect the request body as JSON. See JSON Body for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See Single Header below for details.
 * @property singleQueryArgument Inspect a single query argument. See Single Query Argument below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgs(
    public val allQueryArguments: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null,
    public val body: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchBodyArgs>? = null,
    public val cookies: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchCookiesArgs>? =
        null,
    public val headerOrders: Output<List<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgs>>? = null,
    public val headers: Output<List<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchJa3FingerprintArgs>? = null,
    public val jsonBody: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchJsonBodyArgs>? =
        null,
    public val method: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchMethodArgs>? = null,
    public val queryString: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchQueryStringArgs>? = null,
    public val singleHeader: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleHeaderArgs>? = null,
    public val singleQueryArgument: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null,
    public val uriPath: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchUriPathArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headerOrders(
                headerOrders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgsBuilder internal constructor() {
    private var allQueryArguments:
        Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgs>? = null

    private var body: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchBodyArgs>? = null

    private var cookies: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchCookiesArgs>? =
        null

    private var headerOrders:
        Output<List<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgs>>? = null

    private var headers: Output<List<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgs>>? =
        null

    private var ja3Fingerprint:
        Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchJa3FingerprintArgs>? = null

    private var jsonBody: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchJsonBodyArgs>? =
        null

    private var method: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchMethodArgs>? = null

    private var queryString:
        Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchQueryStringArgs>? = null

    private var singleHeader:
        Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleHeaderArgs>? = null

    private var singleQueryArgument:
        Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgs>? = null

    private var uriPath: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchUriPathArgs>? =
        null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("nmvisaigjwuqgjkh")
    public suspend fun allQueryArguments(`value`: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("xihjrmoxmtchucts")
    public suspend fun body(`value`: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("ieacbvdmsupxfeni")
    public suspend fun cookies(`value`: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect the request headers. See Header Order below for details.
     */
    @JvmName("jeplcmnfwjhekikx")
    public suspend fun headerOrders(`value`: Output<List<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = value
    }

    @JvmName("rwtcexvhubudulpn")
    public suspend fun headerOrders(vararg values: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgs>) {
        this.headerOrders = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See Header Order below for details.
     */
    @JvmName("onqqvjokmvjyqscn")
    public suspend fun headerOrders(values: List<Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = Output.all(values)
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("vkaueykyoaynnvep")
    public suspend fun headers(`value`: Output<List<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("vhiqsoflyeaitbuq")
    public suspend fun headers(vararg values: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("wxprkhpklsxgycte")
    public suspend fun headers(values: List<Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("cicxlqvpqnhnxays")
    public suspend fun ja3Fingerprint(`value`: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("nndqxqfdhmecjbks")
    public suspend fun jsonBody(`value`: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("wnnogstjcxdgxqgo")
    public suspend fun method(`value`: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("nruwbqyasesajkmi")
    public suspend fun queryString(`value`: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("vahfegcypcijphux")
    public suspend fun singleHeader(`value`: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("fmlwpnrgidrvinwo")
    public suspend fun singleQueryArgument(`value`: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("alhlhjfeqxakstly")
    public suspend fun uriPath(`value`: Output<RuleGroupRuleStatementSqliMatchStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("psolowdmqpoivlrl")
    public suspend fun allQueryArguments(`value`: RuleGroupRuleStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("kvnhusxtacqodopn")
    public suspend fun allQueryArguments(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("etudcoyxulwscfsb")
    public suspend fun body(`value`: RuleGroupRuleStatementSqliMatchStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers.
     */
    @JvmName("tcsmbipdydnaoyjf")
    public suspend fun body(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("fqpwsnwvornlgiht")
    public suspend fun cookies(`value`: RuleGroupRuleStatementSqliMatchStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See Cookies below for details.
     */
    @JvmName("bsqvvykysnvxxuik")
    public suspend fun cookies(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect the request headers. See Header Order below for details.
     */
    @JvmName("rsfjtdldpmhvttsy")
    public suspend fun headerOrders(`value`: List<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect the request headers. See Header Order below for details.
     */
    @JvmName("xrayhppbldsohwht")
    public suspend fun headerOrders(argument: List<suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect the request headers. See Header Order below for details.
     */
    @JvmName("lfrphgnqnjnjyctd")
    public suspend fun headerOrders(vararg argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect the request headers. See Header Order below for details.
     */
    @JvmName("eyavfarydrhmyndw")
    public suspend fun headerOrders(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param values Inspect the request headers. See Header Order below for details.
     */
    @JvmName("vmwnhvxmturimwyo")
    public suspend fun headerOrders(vararg values: RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param value Inspect the request headers. See Headers below for details.
     */
    @JvmName("mfqqdahbnegexjsd")
    public suspend fun headers(`value`: List<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("ejiimufrsnxdkvtg")
    public suspend fun headers(argument: List<suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("apqjpwijofwpvbcy")
    public suspend fun headers(vararg argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See Headers below for details.
     */
    @JvmName("wvnjukcchwtojoek")
    public suspend fun headers(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See Headers below for details.
     */
    @JvmName("bptlecftfvqwosbk")
    public suspend fun headers(vararg values: RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value
     */
    @JvmName("rfvsidxhthxwcjuc")
    public suspend fun ja3Fingerprint(`value`: RuleGroupRuleStatementSqliMatchStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument
     */
    @JvmName("attwsrohjroppgyt")
    public suspend fun ja3Fingerprint(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("kpgpmwrqxwnnfmny")
    public suspend fun jsonBody(`value`: RuleGroupRuleStatementSqliMatchStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See JSON Body for details.
     */
    @JvmName("qiivqiuaovsjovke")
    public suspend fun jsonBody(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("mimrppkccujhvjap")
    public suspend fun method(`value`: RuleGroupRuleStatementSqliMatchStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("kvmcpbfbrpsjcafm")
    public suspend fun method(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("uhhkrfsvgpgrroew")
    public suspend fun queryString(`value`: RuleGroupRuleStatementSqliMatchStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("pxoxnkruxannixkl")
    public suspend fun queryString(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See Single Header below for details.
     */
    @JvmName("otphffmhuhcijufe")
    public suspend fun singleHeader(`value`: RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See Single Header below for details.
     */
    @JvmName("wirfnnbxuaeixrdd")
    public suspend fun singleHeader(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("lapftbhwakyfxdgi")
    public suspend fun singleQueryArgument(`value`: RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See Single Query Argument below for details.
     */
    @JvmName("redvqrgfsheypagx")
    public suspend fun singleQueryArgument(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("luybegqkasefcrjw")
    public suspend fun uriPath(`value`: RuleGroupRuleStatementSqliMatchStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("iyyuqylsuabvvght")
    public suspend fun uriPath(argument: suspend RuleGroupRuleStatementSqliMatchStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgs =
        RuleGroupRuleStatementSqliMatchStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headerOrders = headerOrders,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
