@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementXssMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementXssMatchStatementArgs(
    public val fieldToMatch: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchArgs>? = null,
    public val textTransformations: Output<List<RuleGroupRuleStatementXssMatchStatementTextTransformationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementXssMatchStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementXssMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementXssMatchStatementArgs.builder()
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleStatementXssMatchStatementArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementXssMatchStatementArgsBuilder internal constructor() {
    private var fieldToMatch: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchArgs>? = null

    private var textTransformations:
        Output<List<RuleGroupRuleStatementXssMatchStatementTextTransformationArgs>>? = null

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("ivxgeughjjtyhodb")
    public suspend fun fieldToMatch(`value`: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("tnglljngdjcmwhjb")
    public suspend fun textTransformations(`value`: Output<List<RuleGroupRuleStatementXssMatchStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("ggjhrnexrtxksogj")
    public suspend fun textTransformations(vararg values: Output<RuleGroupRuleStatementXssMatchStatementTextTransformationArgs>) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("ligtnedodgecscah")
    public suspend fun textTransformations(values: List<Output<RuleGroupRuleStatementXssMatchStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("kliyewimgrinfivi")
    public suspend fun fieldToMatch(`value`: RuleGroupRuleStatementXssMatchStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
     */
    @JvmName("cmyxmvpmaiihlneo")
    public suspend fun fieldToMatch(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleStatementXssMatchStatementFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("gelmwhperridsapd")
    public suspend fun textTransformations(`value`: List<RuleGroupRuleStatementXssMatchStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("eljxiruvfsvwepxk")
    public suspend fun textTransformations(argument: List<suspend RuleGroupRuleStatementXssMatchStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementXssMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("stcjakdccvcddsxr")
    public suspend fun textTransformations(vararg argument: suspend RuleGroupRuleStatementXssMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleStatementXssMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("sbmltwxyxqjjvgpb")
    public suspend fun textTransformations(argument: suspend RuleGroupRuleStatementXssMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleStatementXssMatchStatementTextTransformationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
     * At least one required.
     * See Text Transformation below for details.
     */
    @JvmName("ivqjechdbacpgxln")
    public suspend fun textTransformations(vararg values: RuleGroupRuleStatementXssMatchStatementTextTransformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): RuleGroupRuleStatementXssMatchStatementArgs =
        RuleGroupRuleStatementXssMatchStatementArgs(
            fieldToMatch = fieldToMatch,
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
