@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property matchPattern The filter to use to identify the subset of headers to inspect in a web request. The `match_pattern` block supports only one of the following arguments:
 * @property matchScope The parts of the headers to inspect with the rule inspection criteria. If you specify `All`, AWS WAF inspects both keys and values. Valid values include the following: `ALL`, `Key`, `Value`.
 * @property oversizeHandling Oversize handling tells AWS WAF what to do with a web request when the request component that the rule inspects is over the limits. Valid values include the following: `CONTINUE`, `MATCH`, `NO_MATCH`. See the AWS [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-oversize-handling.html) for more information.
 */
public data class RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs(
    public val matchPattern: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderMatchPatternArgs>,
    public val matchScope: Output<String>,
    public val oversizeHandling: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs.builder()
            .matchPattern(matchPattern.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .matchScope(matchScope.applyValue({ args0 -> args0 }))
            .oversizeHandling(oversizeHandling.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgsBuilder internal constructor() {
    private var matchPattern:
        Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderMatchPatternArgs>? = null

    private var matchScope: Output<String>? = null

    private var oversizeHandling: Output<String>? = null

    /**
     * @param value The filter to use to identify the subset of headers to inspect in a web request. The `match_pattern` block supports only one of the following arguments:
     */
    @JvmName("kyukcufmrqthwckp")
    public suspend fun matchPattern(`value`: Output<RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderMatchPatternArgs>) {
        this.matchPattern = value
    }

    /**
     * @param value The parts of the headers to inspect with the rule inspection criteria. If you specify `All`, AWS WAF inspects both keys and values. Valid values include the following: `ALL`, `Key`, `Value`.
     */
    @JvmName("bxygokrlemvpbtlh")
    public suspend fun matchScope(`value`: Output<String>) {
        this.matchScope = value
    }

    /**
     * @param value Oversize handling tells AWS WAF what to do with a web request when the request component that the rule inspects is over the limits. Valid values include the following: `CONTINUE`, `MATCH`, `NO_MATCH`. See the AWS [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-oversize-handling.html) for more information.
     */
    @JvmName("rsorocuqabituiml")
    public suspend fun oversizeHandling(`value`: Output<String>) {
        this.oversizeHandling = value
    }

    /**
     * @param value The filter to use to identify the subset of headers to inspect in a web request. The `match_pattern` block supports only one of the following arguments:
     */
    @JvmName("itrhghekydqyjgbx")
    public suspend fun matchPattern(`value`: RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderMatchPatternArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchPattern = mapped
    }

    /**
     * @param argument The filter to use to identify the subset of headers to inspect in a web request. The `match_pattern` block supports only one of the following arguments:
     */
    @JvmName("rotdwptsiycoppbk")
    public suspend fun matchPattern(argument: suspend RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderMatchPatternArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderMatchPatternArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.matchPattern = mapped
    }

    /**
     * @param value The parts of the headers to inspect with the rule inspection criteria. If you specify `All`, AWS WAF inspects both keys and values. Valid values include the following: `ALL`, `Key`, `Value`.
     */
    @JvmName("tewhadjekhgfchen")
    public suspend fun matchScope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchScope = mapped
    }

    /**
     * @param value Oversize handling tells AWS WAF what to do with a web request when the request component that the rule inspects is over the limits. Valid values include the following: `CONTINUE`, `MATCH`, `NO_MATCH`. See the AWS [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-oversize-handling.html) for more information.
     */
    @JvmName("fjaqugfqlewkrppu")
    public suspend fun oversizeHandling(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.oversizeHandling = mapped
    }

    internal fun build(): RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs =
        RuleGroupRuleStatementXssMatchStatementFieldToMatchHeaderArgs(
            matchPattern = matchPattern ?: throw PulumiNullFieldException("matchPattern"),
            matchScope = matchScope ?: throw PulumiNullFieldException("matchScope"),
            oversizeHandling = oversizeHandling ?: throw PulumiNullFieldException("oversizeHandling"),
        )
}
