@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.RuleGroupVisibilityConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchMetricsEnabled A boolean indicating whether the associated resource sends metrics to CloudWatch. For the list of available metrics, see [AWS WAF Metrics](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics).
 * @property metricName A friendly name of the CloudWatch metric. The name can contain only alphanumeric characters (A-Z, a-z, 0-9) hyphen(-) and underscore (_), with length from one to 128 characters. It can't contain whitespace or metric names reserved for AWS WAF, for example `All` and `Default_Action`.
 * @property sampledRequestsEnabled A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.
 */
public data class RuleGroupVisibilityConfigArgs(
    public val cloudwatchMetricsEnabled: Output<Boolean>,
    public val metricName: Output<String>,
    public val sampledRequestsEnabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.RuleGroupVisibilityConfigArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.RuleGroupVisibilityConfigArgs =
        com.pulumi.aws.wafv2.inputs.RuleGroupVisibilityConfigArgs.builder()
            .cloudwatchMetricsEnabled(cloudwatchMetricsEnabled.applyValue({ args0 -> args0 }))
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .sampledRequestsEnabled(sampledRequestsEnabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupVisibilityConfigArgs].
 */
@PulumiTagMarker
public class RuleGroupVisibilityConfigArgsBuilder internal constructor() {
    private var cloudwatchMetricsEnabled: Output<Boolean>? = null

    private var metricName: Output<String>? = null

    private var sampledRequestsEnabled: Output<Boolean>? = null

    /**
     * @param value A boolean indicating whether the associated resource sends metrics to CloudWatch. For the list of available metrics, see [AWS WAF Metrics](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics).
     */
    @JvmName("lepdnmlvviwgikfl")
    public suspend fun cloudwatchMetricsEnabled(`value`: Output<Boolean>) {
        this.cloudwatchMetricsEnabled = value
    }

    /**
     * @param value A friendly name of the CloudWatch metric. The name can contain only alphanumeric characters (A-Z, a-z, 0-9) hyphen(-) and underscore (_), with length from one to 128 characters. It can't contain whitespace or metric names reserved for AWS WAF, for example `All` and `Default_Action`.
     */
    @JvmName("axphpvruondgobao")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.
     */
    @JvmName("daellvjkyjggplca")
    public suspend fun sampledRequestsEnabled(`value`: Output<Boolean>) {
        this.sampledRequestsEnabled = value
    }

    /**
     * @param value A boolean indicating whether the associated resource sends metrics to CloudWatch. For the list of available metrics, see [AWS WAF Metrics](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics).
     */
    @JvmName("meuaagqyaneamqmh")
    public suspend fun cloudwatchMetricsEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudwatchMetricsEnabled = mapped
    }

    /**
     * @param value A friendly name of the CloudWatch metric. The name can contain only alphanumeric characters (A-Z, a-z, 0-9) hyphen(-) and underscore (_), with length from one to 128 characters. It can't contain whitespace or metric names reserved for AWS WAF, for example `All` and `Default_Action`.
     */
    @JvmName("eagwvlmawiloxgtb")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.
     */
    @JvmName("iscqarqrioogyynd")
    public suspend fun sampledRequestsEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sampledRequestsEnabled = mapped
    }

    internal fun build(): RuleGroupVisibilityConfigArgs = RuleGroupVisibilityConfigArgs(
        cloudwatchMetricsEnabled = cloudwatchMetricsEnabled ?: throw
            PulumiNullFieldException("cloudwatchMetricsEnabled"),
        metricName = metricName ?: throw PulumiNullFieldException("metricName"),
        sampledRequestsEnabled = sampledRequestsEnabled ?: throw
            PulumiNullFieldException("sampledRequestsEnabled"),
    )
}
