@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyApiGatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultSizeInspectionLimit Specifies the maximum size of the web request body component that an associated Amazon API Gateway REST APIs should send to AWS WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body. Valid values are `KB_16`, `KB_32`, `KB_48` and `KB_64`.
 */
public data class WebAclAssociationConfigRequestBodyApiGatewayArgs(
    public val defaultSizeInspectionLimit: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyApiGatewayArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyApiGatewayArgs =
        com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyApiGatewayArgs.builder()
            .defaultSizeInspectionLimit(defaultSizeInspectionLimit.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclAssociationConfigRequestBodyApiGatewayArgs].
 */
@PulumiTagMarker
public class WebAclAssociationConfigRequestBodyApiGatewayArgsBuilder internal constructor() {
    private var defaultSizeInspectionLimit: Output<String>? = null

    /**
     * @param value Specifies the maximum size of the web request body component that an associated Amazon API Gateway REST APIs should send to AWS WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body. Valid values are `KB_16`, `KB_32`, `KB_48` and `KB_64`.
     */
    @JvmName("ppvnggnuqsmykqel")
    public suspend fun defaultSizeInspectionLimit(`value`: Output<String>) {
        this.defaultSizeInspectionLimit = value
    }

    /**
     * @param value Specifies the maximum size of the web request body component that an associated Amazon API Gateway REST APIs should send to AWS WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body. Valid values are `KB_16`, `KB_32`, `KB_48` and `KB_64`.
     */
    @JvmName("aqbsbdxwvvjoqhmn")
    public suspend fun defaultSizeInspectionLimit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultSizeInspectionLimit = mapped
    }

    internal fun build(): WebAclAssociationConfigRequestBodyApiGatewayArgs =
        WebAclAssociationConfigRequestBodyApiGatewayArgs(
            defaultSizeInspectionLimit = defaultSizeInspectionLimit ?: throw
                PulumiNullFieldException("defaultSizeInspectionLimit"),
        )
}
