@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property apiGateways Customizes the request body that your protected Amazon API Gateway REST APIs forward to AWS WAF for inspection. Applicable only when `scope` is set to `CLOUDFRONT`. See `api_gateway` below for details.
 * @property appRunnerServices Customizes the request body that your protected Amazon App Runner services forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `app_runner_service` below for details.
 * @property cloudfronts Customizes the request body that your protected Amazon CloudFront distributions forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cloudfront` below for details.
 * @property cognitoUserPools Customizes the request body that your protected Amazon Cognito user pools forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cognito_user_pool` below for details.
 * @property verifiedAccessInstances Customizes the request body that your protected AWS Verfied Access instances forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `verified_access_instance` below for details.
 */
public data class WebAclAssociationConfigRequestBodyArgs(
    public val apiGateways: Output<List<WebAclAssociationConfigRequestBodyApiGatewayArgs>>? = null,
    public val appRunnerServices: Output<List<WebAclAssociationConfigRequestBodyAppRunnerServiceArgs>>? = null,
    public val cloudfronts: Output<List<WebAclAssociationConfigRequestBodyCloudfrontArgs>>? = null,
    public val cognitoUserPools: Output<List<WebAclAssociationConfigRequestBodyCognitoUserPoolArgs>>? =
        null,
    public val verifiedAccessInstances: Output<List<WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyArgs =
        com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyArgs.builder()
            .apiGateways(
                apiGateways?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .appRunnerServices(
                appRunnerServices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cloudfronts(
                cloudfronts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cognitoUserPools(
                cognitoUserPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .verifiedAccessInstances(
                verifiedAccessInstances?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclAssociationConfigRequestBodyArgs].
 */
@PulumiTagMarker
public class WebAclAssociationConfigRequestBodyArgsBuilder internal constructor() {
    private var apiGateways: Output<List<WebAclAssociationConfigRequestBodyApiGatewayArgs>>? = null

    private var appRunnerServices:
        Output<List<WebAclAssociationConfigRequestBodyAppRunnerServiceArgs>>? = null

    private var cloudfronts: Output<List<WebAclAssociationConfigRequestBodyCloudfrontArgs>>? = null

    private var cognitoUserPools: Output<List<WebAclAssociationConfigRequestBodyCognitoUserPoolArgs>>? =
        null

    private var verifiedAccessInstances:
        Output<List<WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgs>>? = null

    /**
     * @param value Customizes the request body that your protected Amazon API Gateway REST APIs forward to AWS WAF for inspection. Applicable only when `scope` is set to `CLOUDFRONT`. See `api_gateway` below for details.
     */
    @JvmName("pioavpjytoecdark")
    public suspend fun apiGateways(`value`: Output<List<WebAclAssociationConfigRequestBodyApiGatewayArgs>>) {
        this.apiGateways = value
    }

    @JvmName("eumjknwpmjmbycxt")
    public suspend fun apiGateways(vararg values: Output<WebAclAssociationConfigRequestBodyApiGatewayArgs>) {
        this.apiGateways = Output.all(values.asList())
    }

    /**
     * @param values Customizes the request body that your protected Amazon API Gateway REST APIs forward to AWS WAF for inspection. Applicable only when `scope` is set to `CLOUDFRONT`. See `api_gateway` below for details.
     */
    @JvmName("vwlvdqayrucpgchc")
    public suspend fun apiGateways(values: List<Output<WebAclAssociationConfigRequestBodyApiGatewayArgs>>) {
        this.apiGateways = Output.all(values)
    }

    /**
     * @param value Customizes the request body that your protected Amazon App Runner services forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `app_runner_service` below for details.
     */
    @JvmName("rshsocenhdtkjkxq")
    public suspend fun appRunnerServices(`value`: Output<List<WebAclAssociationConfigRequestBodyAppRunnerServiceArgs>>) {
        this.appRunnerServices = value
    }

    @JvmName("lixdvibvmehwdyro")
    public suspend fun appRunnerServices(vararg values: Output<WebAclAssociationConfigRequestBodyAppRunnerServiceArgs>) {
        this.appRunnerServices = Output.all(values.asList())
    }

    /**
     * @param values Customizes the request body that your protected Amazon App Runner services forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `app_runner_service` below for details.
     */
    @JvmName("brdyjnthcifnovyf")
    public suspend fun appRunnerServices(values: List<Output<WebAclAssociationConfigRequestBodyAppRunnerServiceArgs>>) {
        this.appRunnerServices = Output.all(values)
    }

    /**
     * @param value Customizes the request body that your protected Amazon CloudFront distributions forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cloudfront` below for details.
     */
    @JvmName("xygolernwgjtrjyl")
    public suspend fun cloudfronts(`value`: Output<List<WebAclAssociationConfigRequestBodyCloudfrontArgs>>) {
        this.cloudfronts = value
    }

    @JvmName("abkjlcektvujbtfq")
    public suspend fun cloudfronts(vararg values: Output<WebAclAssociationConfigRequestBodyCloudfrontArgs>) {
        this.cloudfronts = Output.all(values.asList())
    }

    /**
     * @param values Customizes the request body that your protected Amazon CloudFront distributions forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cloudfront` below for details.
     */
    @JvmName("watdvctoafkbsudu")
    public suspend fun cloudfronts(values: List<Output<WebAclAssociationConfigRequestBodyCloudfrontArgs>>) {
        this.cloudfronts = Output.all(values)
    }

    /**
     * @param value Customizes the request body that your protected Amazon Cognito user pools forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cognito_user_pool` below for details.
     */
    @JvmName("bpcmjsqjyfcocglc")
    public suspend fun cognitoUserPools(`value`: Output<List<WebAclAssociationConfigRequestBodyCognitoUserPoolArgs>>) {
        this.cognitoUserPools = value
    }

    @JvmName("vqgsiexohqefwomb")
    public suspend fun cognitoUserPools(vararg values: Output<WebAclAssociationConfigRequestBodyCognitoUserPoolArgs>) {
        this.cognitoUserPools = Output.all(values.asList())
    }

    /**
     * @param values Customizes the request body that your protected Amazon Cognito user pools forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cognito_user_pool` below for details.
     */
    @JvmName("jwsngbmsqohmnbll")
    public suspend fun cognitoUserPools(values: List<Output<WebAclAssociationConfigRequestBodyCognitoUserPoolArgs>>) {
        this.cognitoUserPools = Output.all(values)
    }

    /**
     * @param value Customizes the request body that your protected AWS Verfied Access instances forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `verified_access_instance` below for details.
     */
    @JvmName("tmkheiwgabcudneo")
    public suspend fun verifiedAccessInstances(`value`: Output<List<WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgs>>) {
        this.verifiedAccessInstances = value
    }

    @JvmName("abjrptglpownhmrw")
    public suspend fun verifiedAccessInstances(vararg values: Output<WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgs>) {
        this.verifiedAccessInstances = Output.all(values.asList())
    }

    /**
     * @param values Customizes the request body that your protected AWS Verfied Access instances forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `verified_access_instance` below for details.
     */
    @JvmName("cuhssqrwyuyfweyf")
    public suspend fun verifiedAccessInstances(values: List<Output<WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgs>>) {
        this.verifiedAccessInstances = Output.all(values)
    }

    /**
     * @param value Customizes the request body that your protected Amazon API Gateway REST APIs forward to AWS WAF for inspection. Applicable only when `scope` is set to `CLOUDFRONT`. See `api_gateway` below for details.
     */
    @JvmName("jlonfjtvfrtndfie")
    public suspend fun apiGateways(`value`: List<WebAclAssociationConfigRequestBodyApiGatewayArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiGateways = mapped
    }

    /**
     * @param argument Customizes the request body that your protected Amazon API Gateway REST APIs forward to AWS WAF for inspection. Applicable only when `scope` is set to `CLOUDFRONT`. See `api_gateway` below for details.
     */
    @JvmName("ihimdjhuvdiedasq")
    public suspend fun apiGateways(argument: List<suspend WebAclAssociationConfigRequestBodyApiGatewayArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyApiGatewayArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.apiGateways = mapped
    }

    /**
     * @param argument Customizes the request body that your protected Amazon API Gateway REST APIs forward to AWS WAF for inspection. Applicable only when `scope` is set to `CLOUDFRONT`. See `api_gateway` below for details.
     */
    @JvmName("togoayovfrokwblj")
    public suspend fun apiGateways(vararg argument: suspend WebAclAssociationConfigRequestBodyApiGatewayArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyApiGatewayArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.apiGateways = mapped
    }

    /**
     * @param argument Customizes the request body that your protected Amazon API Gateway REST APIs forward to AWS WAF for inspection. Applicable only when `scope` is set to `CLOUDFRONT`. See `api_gateway` below for details.
     */
    @JvmName("dtxiwvjdguowvqvq")
    public suspend fun apiGateways(argument: suspend WebAclAssociationConfigRequestBodyApiGatewayArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebAclAssociationConfigRequestBodyApiGatewayArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.apiGateways = mapped
    }

    /**
     * @param values Customizes the request body that your protected Amazon API Gateway REST APIs forward to AWS WAF for inspection. Applicable only when `scope` is set to `CLOUDFRONT`. See `api_gateway` below for details.
     */
    @JvmName("weekqmlsjmqdmsnq")
    public suspend fun apiGateways(vararg values: WebAclAssociationConfigRequestBodyApiGatewayArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiGateways = mapped
    }

    /**
     * @param value Customizes the request body that your protected Amazon App Runner services forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `app_runner_service` below for details.
     */
    @JvmName("gubobjrrlgbfafux")
    public suspend fun appRunnerServices(`value`: List<WebAclAssociationConfigRequestBodyAppRunnerServiceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appRunnerServices = mapped
    }

    /**
     * @param argument Customizes the request body that your protected Amazon App Runner services forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `app_runner_service` below for details.
     */
    @JvmName("rsbectfnwktmpssg")
    public suspend fun appRunnerServices(argument: List<suspend WebAclAssociationConfigRequestBodyAppRunnerServiceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyAppRunnerServiceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.appRunnerServices = mapped
    }

    /**
     * @param argument Customizes the request body that your protected Amazon App Runner services forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `app_runner_service` below for details.
     */
    @JvmName("mxkteirslmvehxxj")
    public suspend fun appRunnerServices(vararg argument: suspend WebAclAssociationConfigRequestBodyAppRunnerServiceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyAppRunnerServiceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.appRunnerServices = mapped
    }

    /**
     * @param argument Customizes the request body that your protected Amazon App Runner services forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `app_runner_service` below for details.
     */
    @JvmName("hdakwpmtadnmtuwu")
    public suspend fun appRunnerServices(argument: suspend WebAclAssociationConfigRequestBodyAppRunnerServiceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclAssociationConfigRequestBodyAppRunnerServiceArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.appRunnerServices = mapped
    }

    /**
     * @param values Customizes the request body that your protected Amazon App Runner services forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `app_runner_service` below for details.
     */
    @JvmName("iiobmcsxpgstcwva")
    public suspend fun appRunnerServices(vararg values: WebAclAssociationConfigRequestBodyAppRunnerServiceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appRunnerServices = mapped
    }

    /**
     * @param value Customizes the request body that your protected Amazon CloudFront distributions forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cloudfront` below for details.
     */
    @JvmName("hknylgdxttjqihjd")
    public suspend fun cloudfronts(`value`: List<WebAclAssociationConfigRequestBodyCloudfrontArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudfronts = mapped
    }

    /**
     * @param argument Customizes the request body that your protected Amazon CloudFront distributions forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cloudfront` below for details.
     */
    @JvmName("qpgknwmshanuwcvj")
    public suspend fun cloudfronts(argument: List<suspend WebAclAssociationConfigRequestBodyCloudfrontArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyCloudfrontArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudfronts = mapped
    }

    /**
     * @param argument Customizes the request body that your protected Amazon CloudFront distributions forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cloudfront` below for details.
     */
    @JvmName("ntpbfkcjsqppwkqr")
    public suspend fun cloudfronts(vararg argument: suspend WebAclAssociationConfigRequestBodyCloudfrontArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyCloudfrontArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cloudfronts = mapped
    }

    /**
     * @param argument Customizes the request body that your protected Amazon CloudFront distributions forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cloudfront` below for details.
     */
    @JvmName("rfwngvttfoaochja")
    public suspend fun cloudfronts(argument: suspend WebAclAssociationConfigRequestBodyCloudfrontArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebAclAssociationConfigRequestBodyCloudfrontArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cloudfronts = mapped
    }

    /**
     * @param values Customizes the request body that your protected Amazon CloudFront distributions forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cloudfront` below for details.
     */
    @JvmName("bformwfumniywllp")
    public suspend fun cloudfronts(vararg values: WebAclAssociationConfigRequestBodyCloudfrontArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudfronts = mapped
    }

    /**
     * @param value Customizes the request body that your protected Amazon Cognito user pools forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cognito_user_pool` below for details.
     */
    @JvmName("paajyslhybhqamnr")
    public suspend fun cognitoUserPools(`value`: List<WebAclAssociationConfigRequestBodyCognitoUserPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitoUserPools = mapped
    }

    /**
     * @param argument Customizes the request body that your protected Amazon Cognito user pools forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cognito_user_pool` below for details.
     */
    @JvmName("odhwvwcqmnifdbuq")
    public suspend fun cognitoUserPools(argument: List<suspend WebAclAssociationConfigRequestBodyCognitoUserPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyCognitoUserPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cognitoUserPools = mapped
    }

    /**
     * @param argument Customizes the request body that your protected Amazon Cognito user pools forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cognito_user_pool` below for details.
     */
    @JvmName("xnkplbyretnuwrxx")
    public suspend fun cognitoUserPools(vararg argument: suspend WebAclAssociationConfigRequestBodyCognitoUserPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyCognitoUserPoolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cognitoUserPools = mapped
    }

    /**
     * @param argument Customizes the request body that your protected Amazon Cognito user pools forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cognito_user_pool` below for details.
     */
    @JvmName("pftidrrfmcjiueoe")
    public suspend fun cognitoUserPools(argument: suspend WebAclAssociationConfigRequestBodyCognitoUserPoolArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclAssociationConfigRequestBodyCognitoUserPoolArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.cognitoUserPools = mapped
    }

    /**
     * @param values Customizes the request body that your protected Amazon Cognito user pools forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cognito_user_pool` below for details.
     */
    @JvmName("qrferfjxcfovfxem")
    public suspend fun cognitoUserPools(vararg values: WebAclAssociationConfigRequestBodyCognitoUserPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cognitoUserPools = mapped
    }

    /**
     * @param value Customizes the request body that your protected AWS Verfied Access instances forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `verified_access_instance` below for details.
     */
    @JvmName("lalxafwdlbyyetyf")
    public suspend fun verifiedAccessInstances(`value`: List<WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifiedAccessInstances = mapped
    }

    /**
     * @param argument Customizes the request body that your protected AWS Verfied Access instances forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `verified_access_instance` below for details.
     */
    @JvmName("hmdreyihvthauigq")
    public suspend fun verifiedAccessInstances(argument: List<suspend WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.verifiedAccessInstances = mapped
    }

    /**
     * @param argument Customizes the request body that your protected AWS Verfied Access instances forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `verified_access_instance` below for details.
     */
    @JvmName("kaepbbksbutxjcyt")
    public suspend fun verifiedAccessInstances(vararg argument: suspend WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.verifiedAccessInstances = mapped
    }

    /**
     * @param argument Customizes the request body that your protected AWS Verfied Access instances forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `verified_access_instance` below for details.
     */
    @JvmName("vwvxonjxwtefqkbb")
    public suspend fun verifiedAccessInstances(argument: suspend WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.verifiedAccessInstances = mapped
    }

    /**
     * @param values Customizes the request body that your protected AWS Verfied Access instances forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `verified_access_instance` below for details.
     */
    @JvmName("gycpesjvobkskwhp")
    public suspend fun verifiedAccessInstances(vararg values: WebAclAssociationConfigRequestBodyVerifiedAccessInstanceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.verifiedAccessInstances = mapped
    }

    internal fun build(): WebAclAssociationConfigRequestBodyArgs =
        WebAclAssociationConfigRequestBodyArgs(
            apiGateways = apiGateways,
            appRunnerServices = appRunnerServices,
            cloudfronts = cloudfronts,
            cognitoUserPools = cognitoUserPools,
            verifiedAccessInstances = verifiedAccessInstances,
        )
}
