@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyCognitoUserPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultSizeInspectionLimit Specifies the maximum size of the web request body component that an associated Amazon Cognito user pools should send to AWS WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body. Valid values are `KB_16`, `KB_32`, `KB_48` and `KB_64`.
 */
public data class WebAclAssociationConfigRequestBodyCognitoUserPoolArgs(
    public val defaultSizeInspectionLimit: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyCognitoUserPoolArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyCognitoUserPoolArgs =
        com.pulumi.aws.wafv2.inputs.WebAclAssociationConfigRequestBodyCognitoUserPoolArgs.builder()
            .defaultSizeInspectionLimit(defaultSizeInspectionLimit.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclAssociationConfigRequestBodyCognitoUserPoolArgs].
 */
@PulumiTagMarker
public class WebAclAssociationConfigRequestBodyCognitoUserPoolArgsBuilder internal constructor() {
    private var defaultSizeInspectionLimit: Output<String>? = null

    /**
     * @param value Specifies the maximum size of the web request body component that an associated Amazon Cognito user pools should send to AWS WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body. Valid values are `KB_16`, `KB_32`, `KB_48` and `KB_64`.
     */
    @JvmName("gfuojavddlbihjsy")
    public suspend fun defaultSizeInspectionLimit(`value`: Output<String>) {
        this.defaultSizeInspectionLimit = value
    }

    /**
     * @param value Specifies the maximum size of the web request body component that an associated Amazon Cognito user pools should send to AWS WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body. Valid values are `KB_16`, `KB_32`, `KB_48` and `KB_64`.
     */
    @JvmName("hojsnqylxjysnmgq")
    public suspend fun defaultSizeInspectionLimit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultSizeInspectionLimit = mapped
    }

    internal fun build(): WebAclAssociationConfigRequestBodyCognitoUserPoolArgs =
        WebAclAssociationConfigRequestBodyCognitoUserPoolArgs(
            defaultSizeInspectionLimit = defaultSizeInspectionLimit ?: throw
                PulumiNullFieldException("defaultSizeInspectionLimit"),
        )
}
