@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclCaptchaConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property immunityTimeProperty Defines custom immunity time. See `immunity_time_property` below for details.
 */
public data class WebAclCaptchaConfigArgs(
    public val immunityTimeProperty: Output<WebAclCaptchaConfigImmunityTimePropertyArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclCaptchaConfigArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclCaptchaConfigArgs =
        com.pulumi.aws.wafv2.inputs.WebAclCaptchaConfigArgs.builder()
            .immunityTimeProperty(
                immunityTimeProperty?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclCaptchaConfigArgs].
 */
@PulumiTagMarker
public class WebAclCaptchaConfigArgsBuilder internal constructor() {
    private var immunityTimeProperty: Output<WebAclCaptchaConfigImmunityTimePropertyArgs>? = null

    /**
     * @param value Defines custom immunity time. See `immunity_time_property` below for details.
     */
    @JvmName("xnfugrpmtjmtaltd")
    public suspend fun immunityTimeProperty(`value`: Output<WebAclCaptchaConfigImmunityTimePropertyArgs>) {
        this.immunityTimeProperty = value
    }

    /**
     * @param value Defines custom immunity time. See `immunity_time_property` below for details.
     */
    @JvmName("sygsiwobyjjwuano")
    public suspend fun immunityTimeProperty(`value`: WebAclCaptchaConfigImmunityTimePropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immunityTimeProperty = mapped
    }

    /**
     * @param argument Defines custom immunity time. See `immunity_time_property` below for details.
     */
    @JvmName("sxlttgkxetsbhrla")
    public suspend fun immunityTimeProperty(argument: suspend WebAclCaptchaConfigImmunityTimePropertyArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclCaptchaConfigImmunityTimePropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.immunityTimeProperty = mapped
    }

    internal fun build(): WebAclCaptchaConfigArgs = WebAclCaptchaConfigArgs(
        immunityTimeProperty = immunityTimeProperty,
    )
}
