@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclChallengeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property immunityTimeProperty Defines custom immunity time. See `immunity_time_property` below for details.
 */
public data class WebAclChallengeConfigArgs(
    public val immunityTimeProperty: Output<WebAclChallengeConfigImmunityTimePropertyArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclChallengeConfigArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclChallengeConfigArgs =
        com.pulumi.aws.wafv2.inputs.WebAclChallengeConfigArgs.builder()
            .immunityTimeProperty(
                immunityTimeProperty?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclChallengeConfigArgs].
 */
@PulumiTagMarker
public class WebAclChallengeConfigArgsBuilder internal constructor() {
    private var immunityTimeProperty: Output<WebAclChallengeConfigImmunityTimePropertyArgs>? = null

    /**
     * @param value Defines custom immunity time. See `immunity_time_property` below for details.
     */
    @JvmName("emouvholvggoupwh")
    public suspend fun immunityTimeProperty(`value`: Output<WebAclChallengeConfigImmunityTimePropertyArgs>) {
        this.immunityTimeProperty = value
    }

    /**
     * @param value Defines custom immunity time. See `immunity_time_property` below for details.
     */
    @JvmName("oqlhpibvlywuwgpd")
    public suspend fun immunityTimeProperty(`value`: WebAclChallengeConfigImmunityTimePropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immunityTimeProperty = mapped
    }

    /**
     * @param argument Defines custom immunity time. See `immunity_time_property` below for details.
     */
    @JvmName("rcymkvwfnmpdftxh")
    public suspend fun immunityTimeProperty(argument: suspend WebAclChallengeConfigImmunityTimePropertyArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclChallengeConfigImmunityTimePropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.immunityTimeProperty = mapped
    }

    internal fun build(): WebAclChallengeConfigArgs = WebAclChallengeConfigArgs(
        immunityTimeProperty = immunityTimeProperty,
    )
}
