@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclDefaultActionAllowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customRequestHandling Defines custom handling for the web request. See `custom_request_handling` below for details.
 */
public data class WebAclDefaultActionAllowArgs(
    public val customRequestHandling: Output<WebAclDefaultActionAllowCustomRequestHandlingArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclDefaultActionAllowArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclDefaultActionAllowArgs =
        com.pulumi.aws.wafv2.inputs.WebAclDefaultActionAllowArgs.builder()
            .customRequestHandling(
                customRequestHandling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclDefaultActionAllowArgs].
 */
@PulumiTagMarker
public class WebAclDefaultActionAllowArgsBuilder internal constructor() {
    private var customRequestHandling: Output<WebAclDefaultActionAllowCustomRequestHandlingArgs>? =
        null

    /**
     * @param value Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("uubxhplqlvertwtd")
    public suspend fun customRequestHandling(`value`: Output<WebAclDefaultActionAllowCustomRequestHandlingArgs>) {
        this.customRequestHandling = value
    }

    /**
     * @param value Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("ocpwlywthoxhsfwj")
    public suspend fun customRequestHandling(`value`: WebAclDefaultActionAllowCustomRequestHandlingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRequestHandling = mapped
    }

    /**
     * @param argument Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("weprjloyvhrwltar")
    public suspend fun customRequestHandling(argument: suspend WebAclDefaultActionAllowCustomRequestHandlingArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclDefaultActionAllowCustomRequestHandlingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customRequestHandling = mapped
    }

    internal fun build(): WebAclDefaultActionAllowArgs = WebAclDefaultActionAllowArgs(
        customRequestHandling = customRequestHandling,
    )
}
