@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclDefaultActionAllowCustomRequestHandlingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property insertHeaders The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
 */
public data class WebAclDefaultActionAllowCustomRequestHandlingArgs(
    public val insertHeaders: Output<List<WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclDefaultActionAllowCustomRequestHandlingArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclDefaultActionAllowCustomRequestHandlingArgs =
        com.pulumi.aws.wafv2.inputs.WebAclDefaultActionAllowCustomRequestHandlingArgs.builder()
            .insertHeaders(
                insertHeaders.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclDefaultActionAllowCustomRequestHandlingArgs].
 */
@PulumiTagMarker
public class WebAclDefaultActionAllowCustomRequestHandlingArgsBuilder internal constructor() {
    private var insertHeaders:
        Output<List<WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgs>>? = null

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("idvfxlmklttdxfbn")
    public suspend fun insertHeaders(`value`: Output<List<WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = value
    }

    @JvmName("cifhmjukolveibmc")
    public suspend fun insertHeaders(vararg values: Output<WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgs>) {
        this.insertHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("hcmbtwgmlvrpjnmd")
    public suspend fun insertHeaders(values: List<Output<WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = Output.all(values)
    }

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("ropwfrqctrrqyhng")
    public suspend fun insertHeaders(`value`: List<WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("iptbvqqmmhoawsik")
    public suspend fun insertHeaders(argument: List<suspend WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("gwehthdpnyjeiqap")
    public suspend fun insertHeaders(vararg argument: suspend WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("clbrwaiqayhheedv")
    public suspend fun insertHeaders(argument: suspend WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("irqmsuwjxqlpibnq")
    public suspend fun insertHeaders(vararg values: WebAclDefaultActionAllowCustomRequestHandlingInsertHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    internal fun build(): WebAclDefaultActionAllowCustomRequestHandlingArgs =
        WebAclDefaultActionAllowCustomRequestHandlingArgs(
            insertHeaders = insertHeaders ?: throw PulumiNullFieldException("insertHeaders"),
        )
}
