@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property behavior Parameter that determines how to handle logs that meet the conditions and requirements of the filter. The valid values for `behavior` are `KEEP` or `DROP`.
 * @property conditions Match condition(s) for the filter. See Condition below for more details.
 * @property requirement Logic to apply to the filtering conditions. You can specify that a log must match all conditions or at least one condition in order to satisfy the filter. Valid values for `requirement` are `MEETS_ALL` or `MEETS_ANY`.
 */
public data class WebAclLoggingConfigurationLoggingFilterFilterArgs(
    public val behavior: Output<String>,
    public val conditions: Output<List<WebAclLoggingConfigurationLoggingFilterFilterConditionArgs>>,
    public val requirement: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterArgs =
        com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterArgs.builder()
            .behavior(behavior.applyValue({ args0 -> args0 }))
            .conditions(
                conditions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .requirement(requirement.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclLoggingConfigurationLoggingFilterFilterArgs].
 */
@PulumiTagMarker
public class WebAclLoggingConfigurationLoggingFilterFilterArgsBuilder internal constructor() {
    private var behavior: Output<String>? = null

    private var conditions: Output<List<WebAclLoggingConfigurationLoggingFilterFilterConditionArgs>>? =
        null

    private var requirement: Output<String>? = null

    /**
     * @param value Parameter that determines how to handle logs that meet the conditions and requirements of the filter. The valid values for `behavior` are `KEEP` or `DROP`.
     */
    @JvmName("fwodercoqaofdhou")
    public suspend fun behavior(`value`: Output<String>) {
        this.behavior = value
    }

    /**
     * @param value Match condition(s) for the filter. See Condition below for more details.
     */
    @JvmName("ufpelmihbmdtsled")
    public suspend fun conditions(`value`: Output<List<WebAclLoggingConfigurationLoggingFilterFilterConditionArgs>>) {
        this.conditions = value
    }

    @JvmName("nudeqssbeyufrffv")
    public suspend fun conditions(vararg values: Output<WebAclLoggingConfigurationLoggingFilterFilterConditionArgs>) {
        this.conditions = Output.all(values.asList())
    }

    /**
     * @param values Match condition(s) for the filter. See Condition below for more details.
     */
    @JvmName("jajudqiotpxlansq")
    public suspend fun conditions(values: List<Output<WebAclLoggingConfigurationLoggingFilterFilterConditionArgs>>) {
        this.conditions = Output.all(values)
    }

    /**
     * @param value Logic to apply to the filtering conditions. You can specify that a log must match all conditions or at least one condition in order to satisfy the filter. Valid values for `requirement` are `MEETS_ALL` or `MEETS_ANY`.
     */
    @JvmName("tsdmtcsjxuiadbcp")
    public suspend fun requirement(`value`: Output<String>) {
        this.requirement = value
    }

    /**
     * @param value Parameter that determines how to handle logs that meet the conditions and requirements of the filter. The valid values for `behavior` are `KEEP` or `DROP`.
     */
    @JvmName("tedmlqkmfdjsfpwg")
    public suspend fun behavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.behavior = mapped
    }

    /**
     * @param value Match condition(s) for the filter. See Condition below for more details.
     */
    @JvmName("riqxtwnaqnwvrlkd")
    public suspend fun conditions(`value`: List<WebAclLoggingConfigurationLoggingFilterFilterConditionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param argument Match condition(s) for the filter. See Condition below for more details.
     */
    @JvmName("xvohmnfbtlsbyhfd")
    public suspend fun conditions(argument: List<suspend WebAclLoggingConfigurationLoggingFilterFilterConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclLoggingConfigurationLoggingFilterFilterConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument Match condition(s) for the filter. See Condition below for more details.
     */
    @JvmName("cjmpglrlhvrgscgp")
    public suspend fun conditions(vararg argument: suspend WebAclLoggingConfigurationLoggingFilterFilterConditionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclLoggingConfigurationLoggingFilterFilterConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument Match condition(s) for the filter. See Condition below for more details.
     */
    @JvmName("hiqptkoynysjggcy")
    public suspend fun conditions(argument: suspend WebAclLoggingConfigurationLoggingFilterFilterConditionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclLoggingConfigurationLoggingFilterFilterConditionArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param values Match condition(s) for the filter. See Condition below for more details.
     */
    @JvmName("bxmnqhqbvtuqosqx")
    public suspend fun conditions(vararg values: WebAclLoggingConfigurationLoggingFilterFilterConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value Logic to apply to the filtering conditions. You can specify that a log must match all conditions or at least one condition in order to satisfy the filter. Valid values for `requirement` are `MEETS_ALL` or `MEETS_ANY`.
     */
    @JvmName("cwajchfsqondlkda")
    public suspend fun requirement(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requirement = mapped
    }

    internal fun build(): WebAclLoggingConfigurationLoggingFilterFilterArgs =
        WebAclLoggingConfigurationLoggingFilterFilterArgs(
            behavior = behavior ?: throw PulumiNullFieldException("behavior"),
            conditions = conditions ?: throw PulumiNullFieldException("conditions"),
            requirement = requirement ?: throw PulumiNullFieldException("requirement"),
        )
}
