@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property actionCondition Configuration for a single action condition. See Action Condition below for more details.
 * @property labelNameCondition Condition for a single label name. See Label Name Condition below for more details.
 */
public data class WebAclLoggingConfigurationLoggingFilterFilterConditionArgs(
    public val actionCondition: Output<WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs>? = null,
    public val labelNameCondition: Output<WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterConditionArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterConditionArgs =
        com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterConditionArgs.builder()
            .actionCondition(actionCondition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labelNameCondition(
                labelNameCondition?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclLoggingConfigurationLoggingFilterFilterConditionArgs].
 */
@PulumiTagMarker
public class WebAclLoggingConfigurationLoggingFilterFilterConditionArgsBuilder internal constructor() {
    private var actionCondition:
        Output<WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs>? = null

    private var labelNameCondition:
        Output<WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs>? = null

    /**
     * @param value Configuration for a single action condition. See Action Condition below for more details.
     */
    @JvmName("dpxthttbubyojnem")
    public suspend fun actionCondition(`value`: Output<WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs>) {
        this.actionCondition = value
    }

    /**
     * @param value Condition for a single label name. See Label Name Condition below for more details.
     */
    @JvmName("mxabmrtoldkdkakq")
    public suspend fun labelNameCondition(`value`: Output<WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs>) {
        this.labelNameCondition = value
    }

    /**
     * @param value Configuration for a single action condition. See Action Condition below for more details.
     */
    @JvmName("nmdgsggoxyhfafdy")
    public suspend fun actionCondition(`value`: WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionCondition = mapped
    }

    /**
     * @param argument Configuration for a single action condition. See Action Condition below for more details.
     */
    @JvmName("houyfngajsurrmgi")
    public suspend fun actionCondition(argument: suspend WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclLoggingConfigurationLoggingFilterFilterConditionActionConditionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.actionCondition = mapped
    }

    /**
     * @param value Condition for a single label name. See Label Name Condition below for more details.
     */
    @JvmName("ddgaktvrsgfmytos")
    public suspend fun labelNameCondition(`value`: WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelNameCondition = mapped
    }

    /**
     * @param argument Condition for a single label name. See Label Name Condition below for more details.
     */
    @JvmName("byurgqqlyijxgxiq")
    public suspend fun labelNameCondition(argument: suspend WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.labelNameCondition = mapped
    }

    internal fun build(): WebAclLoggingConfigurationLoggingFilterFilterConditionArgs =
        WebAclLoggingConfigurationLoggingFilterFilterConditionArgs(
            actionCondition = actionCondition,
            labelNameCondition = labelNameCondition,
        )
}
