@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property labelName Name of the label that a log record must contain in order to meet the condition. It must be a fully qualified label name, which includes a prefix, optional namespaces, and the label name itself. The prefix identifies the rule group or web ACL context of the rule that added the label.
 */
public data class WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs(
    public val labelName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs =
        com.pulumi.aws.wafv2.inputs.WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs.builder()
            .labelName(labelName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs].
 */
@PulumiTagMarker
public class WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgsBuilder
internal constructor() {
    private var labelName: Output<String>? = null

    /**
     * @param value Name of the label that a log record must contain in order to meet the condition. It must be a fully qualified label name, which includes a prefix, optional namespaces, and the label name itself. The prefix identifies the rule group or web ACL context of the rule that added the label.
     */
    @JvmName("svbikqjcdthhokoe")
    public suspend fun labelName(`value`: Output<String>) {
        this.labelName = value
    }

    /**
     * @param value Name of the label that a log record must contain in order to meet the condition. It must be a fully qualified label name, which includes a prefix, optional namespaces, and the label name itself. The prefix identifies the rule group or web ACL context of the rule that added the label.
     */
    @JvmName("ofbjydutafxfcknv")
    public suspend fun labelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labelName = mapped
    }

    internal fun build(): WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs = WebAclLoggingConfigurationLoggingFilterFilterConditionLabelNameConditionArgs(
        labelName = labelName ?: throw PulumiNullFieldException("labelName"),
    )
}
