@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleActionAllowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customRequestHandling Defines custom handling for the web request. See `custom_request_handling` below for details.
 */
public data class WebAclRuleActionAllowArgs(
    public val customRequestHandling: Output<WebAclRuleActionAllowCustomRequestHandlingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleActionAllowArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleActionAllowArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleActionAllowArgs.builder()
            .customRequestHandling(
                customRequestHandling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleActionAllowArgs].
 */
@PulumiTagMarker
public class WebAclRuleActionAllowArgsBuilder internal constructor() {
    private var customRequestHandling: Output<WebAclRuleActionAllowCustomRequestHandlingArgs>? = null

    /**
     * @param value Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("uwfyjvnihcbjemll")
    public suspend fun customRequestHandling(`value`: Output<WebAclRuleActionAllowCustomRequestHandlingArgs>) {
        this.customRequestHandling = value
    }

    /**
     * @param value Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("uqrasjqoxlcfixym")
    public suspend fun customRequestHandling(`value`: WebAclRuleActionAllowCustomRequestHandlingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRequestHandling = mapped
    }

    /**
     * @param argument Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("xhawxskrxytbatuw")
    public suspend fun customRequestHandling(argument: suspend WebAclRuleActionAllowCustomRequestHandlingArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleActionAllowCustomRequestHandlingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customRequestHandling = mapped
    }

    internal fun build(): WebAclRuleActionAllowArgs = WebAclRuleActionAllowArgs(
        customRequestHandling = customRequestHandling,
    )
}
