@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleActionAllowCustomRequestHandlingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property insertHeaders The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
 */
public data class WebAclRuleActionAllowCustomRequestHandlingArgs(
    public val insertHeaders: Output<List<WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleActionAllowCustomRequestHandlingArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleActionAllowCustomRequestHandlingArgs = com.pulumi.aws.wafv2.inputs.WebAclRuleActionAllowCustomRequestHandlingArgs.builder()
        .insertHeaders(
            insertHeaders.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        ).build()
}

/**
 * Builder for [WebAclRuleActionAllowCustomRequestHandlingArgs].
 */
@PulumiTagMarker
public class WebAclRuleActionAllowCustomRequestHandlingArgsBuilder internal constructor() {
    private var insertHeaders:
        Output<List<WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgs>>? = null

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("colrascktsvpqvaf")
    public suspend fun insertHeaders(`value`: Output<List<WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = value
    }

    @JvmName("blpgoheiljrgkpfx")
    public suspend fun insertHeaders(vararg values: Output<WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgs>) {
        this.insertHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("arsgdaqffjaqlbgj")
    public suspend fun insertHeaders(values: List<Output<WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = Output.all(values)
    }

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("tsdyqovfuuoqdkup")
    public suspend fun insertHeaders(`value`: List<WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("lvspwlhxfscnrctg")
    public suspend fun insertHeaders(argument: List<suspend WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("wiplnodpgjnltiwd")
    public suspend fun insertHeaders(vararg argument: suspend WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("cisigewbjacbnake")
    public suspend fun insertHeaders(argument: suspend WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("jnweeoxxisbowkkv")
    public suspend fun insertHeaders(vararg values: WebAclRuleActionAllowCustomRequestHandlingInsertHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    internal fun build(): WebAclRuleActionAllowCustomRequestHandlingArgs =
        WebAclRuleActionAllowCustomRequestHandlingArgs(
            insertHeaders = insertHeaders ?: throw PulumiNullFieldException("insertHeaders"),
        )
}
