@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleActionCaptchaCustomRequestHandlingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property insertHeaders The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
 */
public data class WebAclRuleActionCaptchaCustomRequestHandlingArgs(
    public val insertHeaders: Output<List<WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs>>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleActionCaptchaCustomRequestHandlingArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleActionCaptchaCustomRequestHandlingArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleActionCaptchaCustomRequestHandlingArgs.builder()
            .insertHeaders(
                insertHeaders.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleActionCaptchaCustomRequestHandlingArgs].
 */
@PulumiTagMarker
public class WebAclRuleActionCaptchaCustomRequestHandlingArgsBuilder internal constructor() {
    private var insertHeaders:
        Output<List<WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs>>? = null

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("sijygthcgbpglmch")
    public suspend fun insertHeaders(`value`: Output<List<WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = value
    }

    @JvmName("niriyaunvhxyuefg")
    public suspend fun insertHeaders(vararg values: Output<WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs>) {
        this.insertHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("qkdhdfnckrjpxbbw")
    public suspend fun insertHeaders(values: List<Output<WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs>>) {
        this.insertHeaders = Output.all(values)
    }

    /**
     * @param value The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("hckamfqupvtwxvgm")
    public suspend fun insertHeaders(`value`: List<WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("kqhfrkfrrmyudevg")
    public suspend fun insertHeaders(argument: List<suspend WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("blhsqogtxnagdbmb")
    public suspend fun insertHeaders(vararg argument: suspend WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param argument The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("bbxfciueakfaqkfg")
    public suspend fun insertHeaders(argument: suspend WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.insertHeaders = mapped
    }

    /**
     * @param values The `insert_header` blocks used to define HTTP headers added to the request. See `insert_header` below for details.
     */
    @JvmName("tjdhtrxishcrxdvn")
    public suspend fun insertHeaders(vararg values: WebAclRuleActionCaptchaCustomRequestHandlingInsertHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insertHeaders = mapped
    }

    internal fun build(): WebAclRuleActionCaptchaCustomRequestHandlingArgs =
        WebAclRuleActionCaptchaCustomRequestHandlingArgs(
            insertHeaders = insertHeaders ?: throw PulumiNullFieldException("insertHeaders"),
        )
}
