@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleActionChallengeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customRequestHandling Defines custom handling for the web request. See `custom_request_handling` below for details.
 */
public data class WebAclRuleActionChallengeArgs(
    public val customRequestHandling: Output<WebAclRuleActionChallengeCustomRequestHandlingArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleActionChallengeArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleActionChallengeArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleActionChallengeArgs.builder()
            .customRequestHandling(
                customRequestHandling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleActionChallengeArgs].
 */
@PulumiTagMarker
public class WebAclRuleActionChallengeArgsBuilder internal constructor() {
    private var customRequestHandling: Output<WebAclRuleActionChallengeCustomRequestHandlingArgs>? =
        null

    /**
     * @param value Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("eynomwdmqryblcfg")
    public suspend fun customRequestHandling(`value`: Output<WebAclRuleActionChallengeCustomRequestHandlingArgs>) {
        this.customRequestHandling = value
    }

    /**
     * @param value Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("pnqowengcmtnbxhq")
    public suspend fun customRequestHandling(`value`: WebAclRuleActionChallengeCustomRequestHandlingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRequestHandling = mapped
    }

    /**
     * @param argument Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("vwjfstfvgddibtjw")
    public suspend fun customRequestHandling(argument: suspend WebAclRuleActionChallengeCustomRequestHandlingArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleActionChallengeCustomRequestHandlingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customRequestHandling = mapped
    }

    internal fun build(): WebAclRuleActionChallengeArgs = WebAclRuleActionChallengeArgs(
        customRequestHandling = customRequestHandling,
    )
}
