@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleActionCountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customRequestHandling Defines custom handling for the web request. See `custom_request_handling` below for details.
 */
public data class WebAclRuleActionCountArgs(
    public val customRequestHandling: Output<WebAclRuleActionCountCustomRequestHandlingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleActionCountArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleActionCountArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleActionCountArgs.builder()
            .customRequestHandling(
                customRequestHandling?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleActionCountArgs].
 */
@PulumiTagMarker
public class WebAclRuleActionCountArgsBuilder internal constructor() {
    private var customRequestHandling: Output<WebAclRuleActionCountCustomRequestHandlingArgs>? = null

    /**
     * @param value Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("elxamdyxdqttinyj")
    public suspend fun customRequestHandling(`value`: Output<WebAclRuleActionCountCustomRequestHandlingArgs>) {
        this.customRequestHandling = value
    }

    /**
     * @param value Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("yuoymyvwtdkthnqk")
    public suspend fun customRequestHandling(`value`: WebAclRuleActionCountCustomRequestHandlingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRequestHandling = mapped
    }

    /**
     * @param argument Defines custom handling for the web request. See `custom_request_handling` below for details.
     */
    @JvmName("dtqrthubglglkdnp")
    public suspend fun customRequestHandling(argument: suspend WebAclRuleActionCountCustomRequestHandlingArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleActionCountCustomRequestHandlingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customRequestHandling = mapped
    }

    internal fun build(): WebAclRuleActionCountArgs = WebAclRuleActionCountArgs(
        customRequestHandling = customRequestHandling,
    )
}
