@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property action Action that AWS WAF should take on a web request when it matches the rule's statement. This is used only for rules whose **statements do not reference a rule group**. See `action` for details.
 * @property captchaConfig Specifies how AWS WAF should handle CAPTCHA evaluations. See `captcha_config` below for details.
 * @property name Friendly name of the rule. Note that the provider assumes that rules with names matching this pattern, `^ShieldMitigationRuleGroup_<account-id>_<web-acl-guid>_.*`, are AWS-added for [automatic application layer DDoS mitigation activities](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-automatic-app-layer-response-rg.html). Such rules will be ignored by the provider unless you explicitly include them in your configuration (for example, by using the AWS CLI to discover their properties and creating matching configuration). However, since these rules are owned and managed by AWS, you may get permission errors.
 * @property overrideAction Override action to apply to the rules in a rule group. Used only for rule **statements that reference a rule group**, like `rule_group_reference_statement` and `managed_rule_group_statement`. See `override_action` below for details.
 * @property priority If you define more than one Rule in a WebACL, AWS WAF evaluates each request against the `rules` in order based on the value of `priority`. AWS WAF processes rules with lower priority first.
 * @property ruleLabels Labels to apply to web requests that match the rule match statement. See `rule_label` below for details.
 * @property statement The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See `statement` below for details.
 * @property visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. See `visibility_config` below for details.
 */
public data class WebAclRuleArgs(
    public val action: Output<WebAclRuleActionArgs>? = null,
    public val captchaConfig: Output<WebAclRuleCaptchaConfigArgs>? = null,
    public val name: Output<String>,
    public val overrideAction: Output<WebAclRuleOverrideActionArgs>? = null,
    public val priority: Output<Int>,
    public val ruleLabels: Output<List<WebAclRuleRuleLabelArgs>>? = null,
    public val statement: Output<WebAclRuleStatementArgs>,
    public val visibilityConfig: Output<WebAclRuleVisibilityConfigArgs>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .captchaConfig(captchaConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .overrideAction(overrideAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .ruleLabels(
                ruleLabels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .statement(statement.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .visibilityConfig(
                visibilityConfig.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleArgs].
 */
@PulumiTagMarker
public class WebAclRuleArgsBuilder internal constructor() {
    private var action: Output<WebAclRuleActionArgs>? = null

    private var captchaConfig: Output<WebAclRuleCaptchaConfigArgs>? = null

    private var name: Output<String>? = null

    private var overrideAction: Output<WebAclRuleOverrideActionArgs>? = null

    private var priority: Output<Int>? = null

    private var ruleLabels: Output<List<WebAclRuleRuleLabelArgs>>? = null

    private var statement: Output<WebAclRuleStatementArgs>? = null

    private var visibilityConfig: Output<WebAclRuleVisibilityConfigArgs>? = null

    /**
     * @param value Action that AWS WAF should take on a web request when it matches the rule's statement. This is used only for rules whose **statements do not reference a rule group**. See `action` for details.
     */
    @JvmName("bntxfpuafwlcqaen")
    public suspend fun action(`value`: Output<WebAclRuleActionArgs>) {
        this.action = value
    }

    /**
     * @param value Specifies how AWS WAF should handle CAPTCHA evaluations. See `captcha_config` below for details.
     */
    @JvmName("jfwpnlntakayccji")
    public suspend fun captchaConfig(`value`: Output<WebAclRuleCaptchaConfigArgs>) {
        this.captchaConfig = value
    }

    /**
     * @param value Friendly name of the rule. Note that the provider assumes that rules with names matching this pattern, `^ShieldMitigationRuleGroup_<account-id>_<web-acl-guid>_.*`, are AWS-added for [automatic application layer DDoS mitigation activities](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-automatic-app-layer-response-rg.html). Such rules will be ignored by the provider unless you explicitly include them in your configuration (for example, by using the AWS CLI to discover their properties and creating matching configuration). However, since these rules are owned and managed by AWS, you may get permission errors.
     */
    @JvmName("ncdhwkjpmqnklefc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Override action to apply to the rules in a rule group. Used only for rule **statements that reference a rule group**, like `rule_group_reference_statement` and `managed_rule_group_statement`. See `override_action` below for details.
     */
    @JvmName("mnhjoruwywqtkifb")
    public suspend fun overrideAction(`value`: Output<WebAclRuleOverrideActionArgs>) {
        this.overrideAction = value
    }

    /**
     * @param value If you define more than one Rule in a WebACL, AWS WAF evaluates each request against the `rules` in order based on the value of `priority`. AWS WAF processes rules with lower priority first.
     */
    @JvmName("thgnionjrlkevghn")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Labels to apply to web requests that match the rule match statement. See `rule_label` below for details.
     */
    @JvmName("puolkycjguhgmsyg")
    public suspend fun ruleLabels(`value`: Output<List<WebAclRuleRuleLabelArgs>>) {
        this.ruleLabels = value
    }

    @JvmName("fbuvcwloqbsunehd")
    public suspend fun ruleLabels(vararg values: Output<WebAclRuleRuleLabelArgs>) {
        this.ruleLabels = Output.all(values.asList())
    }

    /**
     * @param values Labels to apply to web requests that match the rule match statement. See `rule_label` below for details.
     */
    @JvmName("jswjugfjthgokoul")
    public suspend fun ruleLabels(values: List<Output<WebAclRuleRuleLabelArgs>>) {
        this.ruleLabels = Output.all(values)
    }

    /**
     * @param value The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See `statement` below for details.
     */
    @JvmName("eambfrmvpcuyoxhk")
    public suspend fun statement(`value`: Output<WebAclRuleStatementArgs>) {
        this.statement = value
    }

    /**
     * @param value Defines and enables Amazon CloudWatch metrics and web request sample collection. See `visibility_config` below for details.
     */
    @JvmName("xxdkcmhqyxgbksfr")
    public suspend fun visibilityConfig(`value`: Output<WebAclRuleVisibilityConfigArgs>) {
        this.visibilityConfig = value
    }

    /**
     * @param value Action that AWS WAF should take on a web request when it matches the rule's statement. This is used only for rules whose **statements do not reference a rule group**. See `action` for details.
     */
    @JvmName("duuiggobcxtkwqvi")
    public suspend fun action(`value`: WebAclRuleActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument Action that AWS WAF should take on a web request when it matches the rule's statement. This is used only for rules whose **statements do not reference a rule group**. See `action` for details.
     */
    @JvmName("rtttlqwhtupkxthq")
    public suspend fun action(argument: suspend WebAclRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Specifies how AWS WAF should handle CAPTCHA evaluations. See `captcha_config` below for details.
     */
    @JvmName("qgxwvqputiipxhwr")
    public suspend fun captchaConfig(`value`: WebAclRuleCaptchaConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captchaConfig = mapped
    }

    /**
     * @param argument Specifies how AWS WAF should handle CAPTCHA evaluations. See `captcha_config` below for details.
     */
    @JvmName("fbgammfemwfucdtn")
    public suspend fun captchaConfig(argument: suspend WebAclRuleCaptchaConfigArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleCaptchaConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.captchaConfig = mapped
    }

    /**
     * @param value Friendly name of the rule. Note that the provider assumes that rules with names matching this pattern, `^ShieldMitigationRuleGroup_<account-id>_<web-acl-guid>_.*`, are AWS-added for [automatic application layer DDoS mitigation activities](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-automatic-app-layer-response-rg.html). Such rules will be ignored by the provider unless you explicitly include them in your configuration (for example, by using the AWS CLI to discover their properties and creating matching configuration). However, since these rules are owned and managed by AWS, you may get permission errors.
     */
    @JvmName("rskpxwwajoufxwvb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Override action to apply to the rules in a rule group. Used only for rule **statements that reference a rule group**, like `rule_group_reference_statement` and `managed_rule_group_statement`. See `override_action` below for details.
     */
    @JvmName("xcaidussngvepcco")
    public suspend fun overrideAction(`value`: WebAclRuleOverrideActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideAction = mapped
    }

    /**
     * @param argument Override action to apply to the rules in a rule group. Used only for rule **statements that reference a rule group**, like `rule_group_reference_statement` and `managed_rule_group_statement`. See `override_action` below for details.
     */
    @JvmName("qelovsxavtikprjf")
    public suspend fun overrideAction(argument: suspend WebAclRuleOverrideActionArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleOverrideActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.overrideAction = mapped
    }

    /**
     * @param value If you define more than one Rule in a WebACL, AWS WAF evaluates each request against the `rules` in order based on the value of `priority`. AWS WAF processes rules with lower priority first.
     */
    @JvmName("gwfvijgdgybnmhnp")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Labels to apply to web requests that match the rule match statement. See `rule_label` below for details.
     */
    @JvmName("mfauernrxtpiehfq")
    public suspend fun ruleLabels(`value`: List<WebAclRuleRuleLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleLabels = mapped
    }

    /**
     * @param argument Labels to apply to web requests that match the rule match statement. See `rule_label` below for details.
     */
    @JvmName("eqevpilniqylkrfi")
    public suspend fun ruleLabels(argument: List<suspend WebAclRuleRuleLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleRuleLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleLabels = mapped
    }

    /**
     * @param argument Labels to apply to web requests that match the rule match statement. See `rule_label` below for details.
     */
    @JvmName("enghjhuqnysplvuu")
    public suspend fun ruleLabels(vararg argument: suspend WebAclRuleRuleLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleRuleLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleLabels = mapped
    }

    /**
     * @param argument Labels to apply to web requests that match the rule match statement. See `rule_label` below for details.
     */
    @JvmName("vlcchaidhwsbwstu")
    public suspend fun ruleLabels(argument: suspend WebAclRuleRuleLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebAclRuleRuleLabelArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ruleLabels = mapped
    }

    /**
     * @param values Labels to apply to web requests that match the rule match statement. See `rule_label` below for details.
     */
    @JvmName("cffwqsjtraihkqgg")
    public suspend fun ruleLabels(vararg values: WebAclRuleRuleLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleLabels = mapped
    }

    /**
     * @param value The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See `statement` below for details.
     */
    @JvmName("ajaplmujuhnlcvma")
    public suspend fun statement(`value`: WebAclRuleStatementArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statement = mapped
    }

    /**
     * @param argument The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See `statement` below for details.
     */
    @JvmName("qexyatvbyxvidlsi")
    public suspend fun statement(argument: suspend WebAclRuleStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.statement = mapped
    }

    /**
     * @param value Defines and enables Amazon CloudWatch metrics and web request sample collection. See `visibility_config` below for details.
     */
    @JvmName("rughenlbwfwunupu")
    public suspend fun visibilityConfig(`value`: WebAclRuleVisibilityConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.visibilityConfig = mapped
    }

    /**
     * @param argument Defines and enables Amazon CloudWatch metrics and web request sample collection. See `visibility_config` below for details.
     */
    @JvmName("gydusldyocqgwjgy")
    public suspend fun visibilityConfig(argument: suspend WebAclRuleVisibilityConfigArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleVisibilityConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.visibilityConfig = mapped
    }

    internal fun build(): WebAclRuleArgs = WebAclRuleArgs(
        action = action,
        captchaConfig = captchaConfig,
        name = name ?: throw PulumiNullFieldException("name"),
        overrideAction = overrideAction,
        priority = priority ?: throw PulumiNullFieldException("priority"),
        ruleLabels = ruleLabels,
        statement = statement ?: throw PulumiNullFieldException("statement"),
        visibilityConfig = visibilityConfig ?: throw PulumiNullFieldException("visibilityConfig"),
    )
}
