@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleCaptchaConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property immunityTimeProperty Defines custom immunity time. See `immunity_time_property` below for details.
 */
public data class WebAclRuleCaptchaConfigArgs(
    public val immunityTimeProperty: Output<WebAclRuleCaptchaConfigImmunityTimePropertyArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleCaptchaConfigArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleCaptchaConfigArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleCaptchaConfigArgs.builder()
            .immunityTimeProperty(
                immunityTimeProperty?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleCaptchaConfigArgs].
 */
@PulumiTagMarker
public class WebAclRuleCaptchaConfigArgsBuilder internal constructor() {
    private var immunityTimeProperty: Output<WebAclRuleCaptchaConfigImmunityTimePropertyArgs>? = null

    /**
     * @param value Defines custom immunity time. See `immunity_time_property` below for details.
     */
    @JvmName("fpujwfeesnqyfych")
    public suspend fun immunityTimeProperty(`value`: Output<WebAclRuleCaptchaConfigImmunityTimePropertyArgs>) {
        this.immunityTimeProperty = value
    }

    /**
     * @param value Defines custom immunity time. See `immunity_time_property` below for details.
     */
    @JvmName("ohbvhtvofkpwkubm")
    public suspend fun immunityTimeProperty(`value`: WebAclRuleCaptchaConfigImmunityTimePropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immunityTimeProperty = mapped
    }

    /**
     * @param argument Defines custom immunity time. See `immunity_time_property` below for details.
     */
    @JvmName("fdbpdysifkeibysu")
    public suspend fun immunityTimeProperty(argument: suspend WebAclRuleCaptchaConfigImmunityTimePropertyArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleCaptchaConfigImmunityTimePropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.immunityTimeProperty = mapped
    }

    internal fun build(): WebAclRuleCaptchaConfigArgs = WebAclRuleCaptchaConfigArgs(
        immunityTimeProperty = immunityTimeProperty,
    )
}
