@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleOverrideActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property count Override the rule action setting to count (i.e., only count matches). Configured as an empty block `{}`.
 * @property none Don't override the rule action setting. Configured as an empty block `{}`.
 */
public data class WebAclRuleOverrideActionArgs(
    public val count: Output<WebAclRuleOverrideActionCountArgs>? = null,
    public val none: Output<WebAclRuleOverrideActionNoneArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleOverrideActionArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleOverrideActionArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleOverrideActionArgs.builder()
            .count(count?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .none(none?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleOverrideActionArgs].
 */
@PulumiTagMarker
public class WebAclRuleOverrideActionArgsBuilder internal constructor() {
    private var count: Output<WebAclRuleOverrideActionCountArgs>? = null

    private var none: Output<WebAclRuleOverrideActionNoneArgs>? = null

    /**
     * @param value Override the rule action setting to count (i.e., only count matches). Configured as an empty block `{}`.
     */
    @JvmName("xseekhubqdokuimp")
    public suspend fun count(`value`: Output<WebAclRuleOverrideActionCountArgs>) {
        this.count = value
    }

    /**
     * @param value Don't override the rule action setting. Configured as an empty block `{}`.
     */
    @JvmName("vkefqpsvtgvrlwrr")
    public suspend fun none(`value`: Output<WebAclRuleOverrideActionNoneArgs>) {
        this.none = value
    }

    /**
     * @param value Override the rule action setting to count (i.e., only count matches). Configured as an empty block `{}`.
     */
    @JvmName("xgulswvmvqffqvoh")
    public suspend fun count(`value`: WebAclRuleOverrideActionCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param argument Override the rule action setting to count (i.e., only count matches). Configured as an empty block `{}`.
     */
    @JvmName("addxdirvypaoxagg")
    public suspend fun count(argument: suspend WebAclRuleOverrideActionCountArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleOverrideActionCountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.count = mapped
    }

    /**
     * @param value Don't override the rule action setting. Configured as an empty block `{}`.
     */
    @JvmName("dyxumaequidigqed")
    public suspend fun none(`value`: WebAclRuleOverrideActionNoneArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.none = mapped
    }

    /**
     * @param argument Don't override the rule action setting. Configured as an empty block `{}`.
     */
    @JvmName("glsdxyvrbmwyqfmf")
    public suspend fun none(argument: suspend WebAclRuleOverrideActionNoneArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleOverrideActionNoneArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.none = mapped
    }

    internal fun build(): WebAclRuleOverrideActionArgs = WebAclRuleOverrideActionArgs(
        count = count,
        none = none,
    )
}
