@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleRuleLabelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Label string.
 */
public data class WebAclRuleRuleLabelArgs(
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleRuleLabelArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleRuleLabelArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleRuleLabelArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleRuleLabelArgs].
 */
@PulumiTagMarker
public class WebAclRuleRuleLabelArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Label string.
     */
    @JvmName("qqxdosoclktvnvnp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Label string.
     */
    @JvmName("ppqqaveyjneqyraq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): WebAclRuleRuleLabelArgs = WebAclRuleRuleLabelArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
