@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property andStatement Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
 * @property byteMatchStatement Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
 * @property geoMatchStatement Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
 * @property ipSetReferenceStatement Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
 * @property labelMatchStatement Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
 * @property managedRuleGroupStatement Rule statement used to run the rules that are defined in a managed rule group.  This statement can not be nested. See `managed_rule_group_statement` below for details.
 * @property notStatement Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
 * @property orStatement Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
 * @property rateBasedStatement Rate-based rule tracks the rate of requests for each originating `IP address`, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any `5-minute` time span. This statement can not be nested. See `rate_based_statement` below for details.
 * @property regexMatchStatement Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
 * @property regexPatternSetReferenceStatement Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
 * @property ruleGroupReferenceStatement Rule statement used to run the rules that are defined in an WAFv2 Rule Group. See `rule_group_reference_statement` below for details.
 * @property sizeConstraintStatement Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
 * @property sqliMatchStatement An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
 * @property xssMatchStatement Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
 */
public data class WebAclRuleStatementArgs(
    public val andStatement: Output<WebAclRuleStatementAndStatementArgs>? = null,
    public val byteMatchStatement: Output<WebAclRuleStatementByteMatchStatementArgs>? = null,
    public val geoMatchStatement: Output<WebAclRuleStatementGeoMatchStatementArgs>? = null,
    public val ipSetReferenceStatement: Output<WebAclRuleStatementIpSetReferenceStatementArgs>? =
        null,
    public val labelMatchStatement: Output<WebAclRuleStatementLabelMatchStatementArgs>? = null,
    public val managedRuleGroupStatement: Output<WebAclRuleStatementManagedRuleGroupStatementArgs>? =
        null,
    public val notStatement: Output<WebAclRuleStatementNotStatementArgs>? = null,
    public val orStatement: Output<WebAclRuleStatementOrStatementArgs>? = null,
    public val rateBasedStatement: Output<WebAclRuleStatementRateBasedStatementArgs>? = null,
    public val regexMatchStatement: Output<WebAclRuleStatementRegexMatchStatementArgs>? = null,
    public val regexPatternSetReferenceStatement: Output<WebAclRuleStatementRegexPatternSetReferenceStatementArgs>? = null,
    public val ruleGroupReferenceStatement: Output<WebAclRuleStatementRuleGroupReferenceStatementArgs>? = null,
    public val sizeConstraintStatement: Output<WebAclRuleStatementSizeConstraintStatementArgs>? =
        null,
    public val sqliMatchStatement: Output<WebAclRuleStatementSqliMatchStatementArgs>? = null,
    public val xssMatchStatement: Output<WebAclRuleStatementXssMatchStatementArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementArgs.builder()
            .andStatement(andStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .byteMatchStatement(
                byteMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .geoMatchStatement(geoMatchStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipSetReferenceStatement(
                ipSetReferenceStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .labelMatchStatement(
                labelMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .managedRuleGroupStatement(
                managedRuleGroupStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .notStatement(notStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .orStatement(orStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rateBasedStatement(
                rateBasedStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .regexMatchStatement(
                regexMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .regexPatternSetReferenceStatement(
                regexPatternSetReferenceStatement?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .ruleGroupReferenceStatement(
                ruleGroupReferenceStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sizeConstraintStatement(
                sizeConstraintStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sqliMatchStatement(
                sqliMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .xssMatchStatement(
                xssMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementArgsBuilder internal constructor() {
    private var andStatement: Output<WebAclRuleStatementAndStatementArgs>? = null

    private var byteMatchStatement: Output<WebAclRuleStatementByteMatchStatementArgs>? = null

    private var geoMatchStatement: Output<WebAclRuleStatementGeoMatchStatementArgs>? = null

    private var ipSetReferenceStatement: Output<WebAclRuleStatementIpSetReferenceStatementArgs>? =
        null

    private var labelMatchStatement: Output<WebAclRuleStatementLabelMatchStatementArgs>? = null

    private var managedRuleGroupStatement: Output<WebAclRuleStatementManagedRuleGroupStatementArgs>? =
        null

    private var notStatement: Output<WebAclRuleStatementNotStatementArgs>? = null

    private var orStatement: Output<WebAclRuleStatementOrStatementArgs>? = null

    private var rateBasedStatement: Output<WebAclRuleStatementRateBasedStatementArgs>? = null

    private var regexMatchStatement: Output<WebAclRuleStatementRegexMatchStatementArgs>? = null

    private var regexPatternSetReferenceStatement:
        Output<WebAclRuleStatementRegexPatternSetReferenceStatementArgs>? = null

    private var ruleGroupReferenceStatement:
        Output<WebAclRuleStatementRuleGroupReferenceStatementArgs>? = null

    private var sizeConstraintStatement: Output<WebAclRuleStatementSizeConstraintStatementArgs>? =
        null

    private var sqliMatchStatement: Output<WebAclRuleStatementSqliMatchStatementArgs>? = null

    private var xssMatchStatement: Output<WebAclRuleStatementXssMatchStatementArgs>? = null

    /**
     * @param value Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
     */
    @JvmName("eonsmmhpfbvcoyhl")
    public suspend fun andStatement(`value`: Output<WebAclRuleStatementAndStatementArgs>) {
        this.andStatement = value
    }

    /**
     * @param value Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
     */
    @JvmName("eyfcykdecidsaaot")
    public suspend fun byteMatchStatement(`value`: Output<WebAclRuleStatementByteMatchStatementArgs>) {
        this.byteMatchStatement = value
    }

    /**
     * @param value Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
     */
    @JvmName("lbocrisbswmsehhl")
    public suspend fun geoMatchStatement(`value`: Output<WebAclRuleStatementGeoMatchStatementArgs>) {
        this.geoMatchStatement = value
    }

    /**
     * @param value Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
     */
    @JvmName("creahuhjhrxksigo")
    public suspend fun ipSetReferenceStatement(`value`: Output<WebAclRuleStatementIpSetReferenceStatementArgs>) {
        this.ipSetReferenceStatement = value
    }

    /**
     * @param value Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
     */
    @JvmName("uopbvkwhdlpeypbd")
    public suspend fun labelMatchStatement(`value`: Output<WebAclRuleStatementLabelMatchStatementArgs>) {
        this.labelMatchStatement = value
    }

    /**
     * @param value Rule statement used to run the rules that are defined in a managed rule group.  This statement can not be nested. See `managed_rule_group_statement` below for details.
     */
    @JvmName("bhxysdphuntyyrbv")
    public suspend fun managedRuleGroupStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementArgs>) {
        this.managedRuleGroupStatement = value
    }

    /**
     * @param value Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
     */
    @JvmName("umsefahcjqusyotn")
    public suspend fun notStatement(`value`: Output<WebAclRuleStatementNotStatementArgs>) {
        this.notStatement = value
    }

    /**
     * @param value Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
     */
    @JvmName("pevlpbpwkrxdewjt")
    public suspend fun orStatement(`value`: Output<WebAclRuleStatementOrStatementArgs>) {
        this.orStatement = value
    }

    /**
     * @param value Rate-based rule tracks the rate of requests for each originating `IP address`, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any `5-minute` time span. This statement can not be nested. See `rate_based_statement` below for details.
     */
    @JvmName("yshhqscddovcyjsa")
    public suspend fun rateBasedStatement(`value`: Output<WebAclRuleStatementRateBasedStatementArgs>) {
        this.rateBasedStatement = value
    }

    /**
     * @param value Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
     */
    @JvmName("dxsunjyhofrnobeg")
    public suspend fun regexMatchStatement(`value`: Output<WebAclRuleStatementRegexMatchStatementArgs>) {
        this.regexMatchStatement = value
    }

    /**
     * @param value Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
     */
    @JvmName("wprfkitdpdevrkrh")
    public suspend fun regexPatternSetReferenceStatement(`value`: Output<WebAclRuleStatementRegexPatternSetReferenceStatementArgs>) {
        this.regexPatternSetReferenceStatement = value
    }

    /**
     * @param value Rule statement used to run the rules that are defined in an WAFv2 Rule Group. See `rule_group_reference_statement` below for details.
     */
    @JvmName("losbggasrbxyrlui")
    public suspend fun ruleGroupReferenceStatement(`value`: Output<WebAclRuleStatementRuleGroupReferenceStatementArgs>) {
        this.ruleGroupReferenceStatement = value
    }

    /**
     * @param value Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
     */
    @JvmName("tgudppyispkrnxge")
    public suspend fun sizeConstraintStatement(`value`: Output<WebAclRuleStatementSizeConstraintStatementArgs>) {
        this.sizeConstraintStatement = value
    }

    /**
     * @param value An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
     */
    @JvmName("eyicsrpvoeifhcne")
    public suspend fun sqliMatchStatement(`value`: Output<WebAclRuleStatementSqliMatchStatementArgs>) {
        this.sqliMatchStatement = value
    }

    /**
     * @param value Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
     */
    @JvmName("gbnqfunempyaekdx")
    public suspend fun xssMatchStatement(`value`: Output<WebAclRuleStatementXssMatchStatementArgs>) {
        this.xssMatchStatement = value
    }

    /**
     * @param value Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
     */
    @JvmName("vbebdafoqalxanhv")
    public suspend fun andStatement(`value`: WebAclRuleStatementAndStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.andStatement = mapped
    }

    /**
     * @param argument Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
     */
    @JvmName("temrvydvtcsskuvm")
    public suspend fun andStatement(argument: suspend WebAclRuleStatementAndStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementAndStatementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.andStatement = mapped
    }

    /**
     * @param value Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
     */
    @JvmName("tbnvaoyipncqnpte")
    public suspend fun byteMatchStatement(`value`: WebAclRuleStatementByteMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.byteMatchStatement = mapped
    }

    /**
     * @param argument Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
     */
    @JvmName("ejanksweddiahlsd")
    public suspend fun byteMatchStatement(argument: suspend WebAclRuleStatementByteMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementByteMatchStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.byteMatchStatement = mapped
    }

    /**
     * @param value Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
     */
    @JvmName("jtddtupxnxhcsqeu")
    public suspend fun geoMatchStatement(`value`: WebAclRuleStatementGeoMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoMatchStatement = mapped
    }

    /**
     * @param argument Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
     */
    @JvmName("jajoiqgkxtbvjnvm")
    public suspend fun geoMatchStatement(argument: suspend WebAclRuleStatementGeoMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementGeoMatchStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.geoMatchStatement = mapped
    }

    /**
     * @param value Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
     */
    @JvmName("ltirlugfbfrnmnkm")
    public suspend fun ipSetReferenceStatement(`value`: WebAclRuleStatementIpSetReferenceStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSetReferenceStatement = mapped
    }

    /**
     * @param argument Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
     */
    @JvmName("wfumexsrbflswgur")
    public suspend fun ipSetReferenceStatement(argument: suspend WebAclRuleStatementIpSetReferenceStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementIpSetReferenceStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ipSetReferenceStatement = mapped
    }

    /**
     * @param value Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
     */
    @JvmName("rogqfpoybyhavshi")
    public suspend fun labelMatchStatement(`value`: WebAclRuleStatementLabelMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelMatchStatement = mapped
    }

    /**
     * @param argument Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
     */
    @JvmName("ewyxkicfmepaswxe")
    public suspend fun labelMatchStatement(argument: suspend WebAclRuleStatementLabelMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementLabelMatchStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.labelMatchStatement = mapped
    }

    /**
     * @param value Rule statement used to run the rules that are defined in a managed rule group.  This statement can not be nested. See `managed_rule_group_statement` below for details.
     */
    @JvmName("rwiinrwwtvnetwld")
    public suspend fun managedRuleGroupStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedRuleGroupStatement = mapped
    }

    /**
     * @param argument Rule statement used to run the rules that are defined in a managed rule group.  This statement can not be nested. See `managed_rule_group_statement` below for details.
     */
    @JvmName("qhprjqncmtttlvhc")
    public suspend fun managedRuleGroupStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementManagedRuleGroupStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedRuleGroupStatement = mapped
    }

    /**
     * @param value Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
     */
    @JvmName("yqdrmbmjjeujpywy")
    public suspend fun notStatement(`value`: WebAclRuleStatementNotStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notStatement = mapped
    }

    /**
     * @param argument Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
     */
    @JvmName("stkbploaeeyapxqp")
    public suspend fun notStatement(argument: suspend WebAclRuleStatementNotStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementNotStatementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.notStatement = mapped
    }

    /**
     * @param value Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
     */
    @JvmName("ilbbnrcksajwpesi")
    public suspend fun orStatement(`value`: WebAclRuleStatementOrStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orStatement = mapped
    }

    /**
     * @param argument Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
     */
    @JvmName("ushnaiiixyrcbdwm")
    public suspend fun orStatement(argument: suspend WebAclRuleStatementOrStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementOrStatementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.orStatement = mapped
    }

    /**
     * @param value Rate-based rule tracks the rate of requests for each originating `IP address`, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any `5-minute` time span. This statement can not be nested. See `rate_based_statement` below for details.
     */
    @JvmName("oxsokhhnhxgwyytv")
    public suspend fun rateBasedStatement(`value`: WebAclRuleStatementRateBasedStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateBasedStatement = mapped
    }

    /**
     * @param argument Rate-based rule tracks the rate of requests for each originating `IP address`, and triggers the rule action when the rate exceeds a limit that you specify on the number of requests in any `5-minute` time span. This statement can not be nested. See `rate_based_statement` below for details.
     */
    @JvmName("rtypsffdhrvmstqe")
    public suspend fun rateBasedStatement(argument: suspend WebAclRuleStatementRateBasedStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementRateBasedStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rateBasedStatement = mapped
    }

    /**
     * @param value Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
     */
    @JvmName("rcexpmnixxuvplbp")
    public suspend fun regexMatchStatement(`value`: WebAclRuleStatementRegexMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexMatchStatement = mapped
    }

    /**
     * @param argument Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
     */
    @JvmName("vvvkpgqrrvwvelwj")
    public suspend fun regexMatchStatement(argument: suspend WebAclRuleStatementRegexMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementRegexMatchStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.regexMatchStatement = mapped
    }

    /**
     * @param value Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
     */
    @JvmName("takryfcysurfaqdj")
    public suspend fun regexPatternSetReferenceStatement(`value`: WebAclRuleStatementRegexPatternSetReferenceStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexPatternSetReferenceStatement = mapped
    }

    /**
     * @param argument Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
     */
    @JvmName("fwxbbsutqsonmgis")
    public suspend fun regexPatternSetReferenceStatement(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementRegexPatternSetReferenceStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.regexPatternSetReferenceStatement = mapped
    }

    /**
     * @param value Rule statement used to run the rules that are defined in an WAFv2 Rule Group. See `rule_group_reference_statement` below for details.
     */
    @JvmName("ckdvvaoycfpueueg")
    public suspend fun ruleGroupReferenceStatement(`value`: WebAclRuleStatementRuleGroupReferenceStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleGroupReferenceStatement = mapped
    }

    /**
     * @param argument Rule statement used to run the rules that are defined in an WAFv2 Rule Group. See `rule_group_reference_statement` below for details.
     */
    @JvmName("oegyqrelrnphoymo")
    public suspend fun ruleGroupReferenceStatement(argument: suspend WebAclRuleStatementRuleGroupReferenceStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementRuleGroupReferenceStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ruleGroupReferenceStatement = mapped
    }

    /**
     * @param value Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
     */
    @JvmName("yxqmoyscwhfjhjqk")
    public suspend fun sizeConstraintStatement(`value`: WebAclRuleStatementSizeConstraintStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeConstraintStatement = mapped
    }

    /**
     * @param argument Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
     */
    @JvmName("uaakelmsjmtvyxhn")
    public suspend fun sizeConstraintStatement(argument: suspend WebAclRuleStatementSizeConstraintStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementSizeConstraintStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sizeConstraintStatement = mapped
    }

    /**
     * @param value An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
     */
    @JvmName("jnqljplfstedvukf")
    public suspend fun sqliMatchStatement(`value`: WebAclRuleStatementSqliMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqliMatchStatement = mapped
    }

    /**
     * @param argument An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
     */
    @JvmName("jmrdbapsbyxxyums")
    public suspend fun sqliMatchStatement(argument: suspend WebAclRuleStatementSqliMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementSqliMatchStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sqliMatchStatement = mapped
    }

    /**
     * @param value Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
     */
    @JvmName("ofwoypnfjkbvpekj")
    public suspend fun xssMatchStatement(`value`: WebAclRuleStatementXssMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xssMatchStatement = mapped
    }

    /**
     * @param argument Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
     */
    @JvmName("cdmlcberehnrkybj")
    public suspend fun xssMatchStatement(argument: suspend WebAclRuleStatementXssMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementXssMatchStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.xssMatchStatement = mapped
    }

    internal fun build(): WebAclRuleStatementArgs = WebAclRuleStatementArgs(
        andStatement = andStatement,
        byteMatchStatement = byteMatchStatement,
        geoMatchStatement = geoMatchStatement,
        ipSetReferenceStatement = ipSetReferenceStatement,
        labelMatchStatement = labelMatchStatement,
        managedRuleGroupStatement = managedRuleGroupStatement,
        notStatement = notStatement,
        orStatement = orStatement,
        rateBasedStatement = rateBasedStatement,
        regexMatchStatement = regexMatchStatement,
        regexPatternSetReferenceStatement = regexPatternSetReferenceStatement,
        ruleGroupReferenceStatement = ruleGroupReferenceStatement,
        sizeConstraintStatement = sizeConstraintStatement,
        sqliMatchStatement = sqliMatchStatement,
        xssMatchStatement = xssMatchStatement,
    )
}
