@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementByteMatchStatementFieldToMatchCookiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property matchPatterns The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either `all`, `included_cookies` or `excluded_cookies`. More details: [CookieMatchPattern](https://docs.aws.amazon.com/waf/latest/APIReference/API_CookieMatchPattern.html)
 * @property matchScope The parts of the cookies to inspect with the rule inspection criteria. If you specify All, AWS WAF inspects both keys and values. Valid values: `ALL`, `KEY`, `VALUE`
 * @property oversizeHandling What AWS WAF should do if the cookies of the request are larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF. Valid values: `CONTINUE`, `MATCH`, `NO_MATCH`.
 */
public data class WebAclRuleStatementByteMatchStatementFieldToMatchCookiesArgs(
    public val matchPatterns: Output<List<WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgs>>,
    public val matchScope: Output<String>,
    public val oversizeHandling: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementByteMatchStatementFieldToMatchCookiesArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementByteMatchStatementFieldToMatchCookiesArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementByteMatchStatementFieldToMatchCookiesArgs.builder()
            .matchPatterns(
                matchPatterns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .matchScope(matchScope.applyValue({ args0 -> args0 }))
            .oversizeHandling(oversizeHandling.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleStatementByteMatchStatementFieldToMatchCookiesArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementByteMatchStatementFieldToMatchCookiesArgsBuilder internal constructor() {
    private var matchPatterns:
        Output<List<WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgs>>? = null

    private var matchScope: Output<String>? = null

    private var oversizeHandling: Output<String>? = null

    /**
     * @param value The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either `all`, `included_cookies` or `excluded_cookies`. More details: [CookieMatchPattern](https://docs.aws.amazon.com/waf/latest/APIReference/API_CookieMatchPattern.html)
     */
    @JvmName("tasrgtooorinhmpo")
    public suspend fun matchPatterns(`value`: Output<List<WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgs>>) {
        this.matchPatterns = value
    }

    @JvmName("kyysghueoyurnbgt")
    public suspend fun matchPatterns(vararg values: Output<WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgs>) {
        this.matchPatterns = Output.all(values.asList())
    }

    /**
     * @param values The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either `all`, `included_cookies` or `excluded_cookies`. More details: [CookieMatchPattern](https://docs.aws.amazon.com/waf/latest/APIReference/API_CookieMatchPattern.html)
     */
    @JvmName("fspgnryqgopmjovk")
    public suspend fun matchPatterns(values: List<Output<WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgs>>) {
        this.matchPatterns = Output.all(values)
    }

    /**
     * @param value The parts of the cookies to inspect with the rule inspection criteria. If you specify All, AWS WAF inspects both keys and values. Valid values: `ALL`, `KEY`, `VALUE`
     */
    @JvmName("nfmmrxclccuqdxdj")
    public suspend fun matchScope(`value`: Output<String>) {
        this.matchScope = value
    }

    /**
     * @param value What AWS WAF should do if the cookies of the request are larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF. Valid values: `CONTINUE`, `MATCH`, `NO_MATCH`.
     */
    @JvmName("wpgngfsvoijxgsjl")
    public suspend fun oversizeHandling(`value`: Output<String>) {
        this.oversizeHandling = value
    }

    /**
     * @param value The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either `all`, `included_cookies` or `excluded_cookies`. More details: [CookieMatchPattern](https://docs.aws.amazon.com/waf/latest/APIReference/API_CookieMatchPattern.html)
     */
    @JvmName("piloksbnstxxhwkw")
    public suspend fun matchPatterns(`value`: List<WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchPatterns = mapped
    }

    /**
     * @param argument The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either `all`, `included_cookies` or `excluded_cookies`. More details: [CookieMatchPattern](https://docs.aws.amazon.com/waf/latest/APIReference/API_CookieMatchPattern.html)
     */
    @JvmName("rtveliqxvrgipnml")
    public suspend fun matchPatterns(argument: List<suspend WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchPatterns = mapped
    }

    /**
     * @param argument The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either `all`, `included_cookies` or `excluded_cookies`. More details: [CookieMatchPattern](https://docs.aws.amazon.com/waf/latest/APIReference/API_CookieMatchPattern.html)
     */
    @JvmName("bysymkpabhsmbeme")
    public suspend fun matchPatterns(vararg argument: suspend WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchPatterns = mapped
    }

    /**
     * @param argument The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either `all`, `included_cookies` or `excluded_cookies`. More details: [CookieMatchPattern](https://docs.aws.amazon.com/waf/latest/APIReference/API_CookieMatchPattern.html)
     */
    @JvmName("hkairlilkovsoabc")
    public suspend fun matchPatterns(argument: suspend WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.matchPatterns = mapped
    }

    /**
     * @param values The filter to use to identify the subset of cookies to inspect in a web request. You must specify exactly one setting: either `all`, `included_cookies` or `excluded_cookies`. More details: [CookieMatchPattern](https://docs.aws.amazon.com/waf/latest/APIReference/API_CookieMatchPattern.html)
     */
    @JvmName("jhaneogksqmskcmh")
    public suspend fun matchPatterns(vararg values: WebAclRuleStatementByteMatchStatementFieldToMatchCookiesMatchPatternArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchPatterns = mapped
    }

    /**
     * @param value The parts of the cookies to inspect with the rule inspection criteria. If you specify All, AWS WAF inspects both keys and values. Valid values: `ALL`, `KEY`, `VALUE`
     */
    @JvmName("fapurodnaublqrki")
    public suspend fun matchScope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchScope = mapped
    }

    /**
     * @param value What AWS WAF should do if the cookies of the request are larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF. Valid values: `CONTINUE`, `MATCH`, `NO_MATCH`.
     */
    @JvmName("jkunffgbupfgwaei")
    public suspend fun oversizeHandling(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.oversizeHandling = mapped
    }

    internal fun build(): WebAclRuleStatementByteMatchStatementFieldToMatchCookiesArgs =
        WebAclRuleStatementByteMatchStatementFieldToMatchCookiesArgs(
            matchPatterns = matchPatterns ?: throw PulumiNullFieldException("matchPatterns"),
            matchScope = matchScope ?: throw PulumiNullFieldException("matchScope"),
            oversizeHandling = oversizeHandling ?: throw PulumiNullFieldException("oversizeHandling"),
        )
}
