@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property all An empty configuration block that is used for inspecting all headers.
 * @property excludedHeaders An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
 * @property includedHeaders An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
 */
public data class WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs(
    public val all: Output<WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternAllArgs>? = null,
    public val excludedHeaders: Output<List<String>>? = null,
    public val includedHeaders: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs.builder()
            .all(all?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .excludedHeaders(excludedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includedHeaders(includedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgsBuilder internal constructor() {
    private var all:
        Output<WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternAllArgs>? = null

    private var excludedHeaders: Output<List<String>>? = null

    private var includedHeaders: Output<List<String>>? = null

    /**
     * @param value An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("uwxikstejqqoiysa")
    public suspend fun all(`value`: Output<WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternAllArgs>) {
        this.all = value
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("jhwjrhklkegsgpqq")
    public suspend fun excludedHeaders(`value`: Output<List<String>>) {
        this.excludedHeaders = value
    }

    @JvmName("jtlbdjhacijtowss")
    public suspend fun excludedHeaders(vararg values: Output<String>) {
        this.excludedHeaders = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("okuhlbwtrdbtcqxb")
    public suspend fun excludedHeaders(values: List<Output<String>>) {
        this.excludedHeaders = Output.all(values)
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("yviajayxovmkgicl")
    public suspend fun includedHeaders(`value`: Output<List<String>>) {
        this.includedHeaders = value
    }

    @JvmName("jxydcpabvikfsbif")
    public suspend fun includedHeaders(vararg values: Output<String>) {
        this.includedHeaders = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("eldkgdhcabbdmbsh")
    public suspend fun includedHeaders(values: List<Output<String>>) {
        this.includedHeaders = Output.all(values)
    }

    /**
     * @param value An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("nillpihyamhvihvb")
    public suspend fun all(`value`: WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternAllArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.all = mapped
    }

    /**
     * @param argument An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("tjmyijxplarwmwox")
    public suspend fun all(argument: suspend WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternAllArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternAllArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.all = mapped
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("mkfaqgbckreksace")
    public suspend fun excludedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedHeaders = mapped
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("xtfpikdnoxnlvjmx")
    public suspend fun excludedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedHeaders = mapped
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("decekqwglbugyfqb")
    public suspend fun includedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedHeaders = mapped
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("jrfiyjtyqsgockbd")
    public suspend fun includedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedHeaders = mapped
    }

    internal fun build(): WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs =
        WebAclRuleStatementByteMatchStatementFieldToMatchHeaderMatchPatternArgs(
            all = all,
            excludedHeaders = excludedHeaders,
            includedHeaders = includedHeaders,
        )
}
