@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementGeoMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property countryCodes Array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
 * @property forwardedIpConfig Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `forwarded_ip_config` below for details.
 */
public data class WebAclRuleStatementGeoMatchStatementArgs(
    public val countryCodes: Output<List<String>>,
    public val forwardedIpConfig: Output<WebAclRuleStatementGeoMatchStatementForwardedIpConfigArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementGeoMatchStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementGeoMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementGeoMatchStatementArgs.builder()
            .countryCodes(countryCodes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .forwardedIpConfig(
                forwardedIpConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementGeoMatchStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementGeoMatchStatementArgsBuilder internal constructor() {
    private var countryCodes: Output<List<String>>? = null

    private var forwardedIpConfig: Output<WebAclRuleStatementGeoMatchStatementForwardedIpConfigArgs>? =
        null

    /**
     * @param value Array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
     */
    @JvmName("krbplrrfcryjdcpo")
    public suspend fun countryCodes(`value`: Output<List<String>>) {
        this.countryCodes = value
    }

    @JvmName("ybsajuspvqjreehe")
    public suspend fun countryCodes(vararg values: Output<String>) {
        this.countryCodes = Output.all(values.asList())
    }

    /**
     * @param values Array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
     */
    @JvmName("tmrtgeflvjroswrs")
    public suspend fun countryCodes(values: List<Output<String>>) {
        this.countryCodes = Output.all(values)
    }

    /**
     * @param value Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `forwarded_ip_config` below for details.
     */
    @JvmName("nwshgssrtpsudbvx")
    public suspend fun forwardedIpConfig(`value`: Output<WebAclRuleStatementGeoMatchStatementForwardedIpConfigArgs>) {
        this.forwardedIpConfig = value
    }

    /**
     * @param value Array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
     */
    @JvmName("wlbmhlrnopepthmc")
    public suspend fun countryCodes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countryCodes = mapped
    }

    /**
     * @param values Array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
     */
    @JvmName("mjliglxphgkjcgij")
    public suspend fun countryCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countryCodes = mapped
    }

    /**
     * @param value Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `forwarded_ip_config` below for details.
     */
    @JvmName("vaycccxldfnygqjx")
    public suspend fun forwardedIpConfig(`value`: WebAclRuleStatementGeoMatchStatementForwardedIpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedIpConfig = mapped
    }

    /**
     * @param argument Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `forwarded_ip_config` below for details.
     */
    @JvmName("emveibaiborkjsab")
    public suspend fun forwardedIpConfig(argument: suspend WebAclRuleStatementGeoMatchStatementForwardedIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementGeoMatchStatementForwardedIpConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.forwardedIpConfig = mapped
    }

    internal fun build(): WebAclRuleStatementGeoMatchStatementArgs =
        WebAclRuleStatementGeoMatchStatementArgs(
            countryCodes = countryCodes ?: throw PulumiNullFieldException("countryCodes"),
            forwardedIpConfig = forwardedIpConfig,
        )
}
