@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property addressFields The names of the fields in the request payload that contain your customer's primary physical address. See `address_fields` for more details.
 * @property emailField The name of the field in the request payload that contains your customer's email. See `email_field` for more details.
 * @property passwordField Details about your login page password field. See `password_field` for more details.
 * @property payloadType The payload type for your login endpoint, either JSON or form encoded.
 * @property phoneNumberFields The names of the fields in the request payload that contain your customer's primary phone number. See `phone_number_fields` for more details.
 * @property usernameField Details about your login page username field. See `username_field` for more details.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs(
    public val addressFields: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionAddressFieldsArgs>? =
        null,
    public val emailField: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionEmailFieldArgs>? =
        null,
    public val passwordField: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPasswordFieldArgs>? =
        null,
    public val payloadType: Output<String>,
    public val phoneNumberFields: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPhoneNumberFieldsArgs>? =
        null,
    public val usernameField: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionUsernameFieldArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs.builder()
            .addressFields(addressFields?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .emailField(emailField?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .passwordField(passwordField?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .payloadType(payloadType.applyValue({ args0 -> args0 }))
            .phoneNumberFields(phoneNumberFields?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .usernameField(usernameField?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgsBuilder
internal constructor() {
    private var addressFields:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionAddressFieldsArgs>? =
        null

    private var emailField:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionEmailFieldArgs>? =
        null

    private var passwordField:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPasswordFieldArgs>? =
        null

    private var payloadType: Output<String>? = null

    private var phoneNumberFields:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPhoneNumberFieldsArgs>? =
        null

    private var usernameField:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionUsernameFieldArgs>? =
        null

    /**
     * @param value The names of the fields in the request payload that contain your customer's primary physical address. See `address_fields` for more details.
     */
    @JvmName("wxamjnuwioqcqudm")
    public suspend fun addressFields(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionAddressFieldsArgs>) {
        this.addressFields = value
    }

    /**
     * @param value The name of the field in the request payload that contains your customer's email. See `email_field` for more details.
     */
    @JvmName("tbaubrfyqafvntrd")
    public suspend fun emailField(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionEmailFieldArgs>) {
        this.emailField = value
    }

    /**
     * @param value Details about your login page password field. See `password_field` for more details.
     */
    @JvmName("eqachuicsrtotdbl")
    public suspend fun passwordField(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPasswordFieldArgs>) {
        this.passwordField = value
    }

    /**
     * @param value The payload type for your login endpoint, either JSON or form encoded.
     */
    @JvmName("deitumdxojlsrtyv")
    public suspend fun payloadType(`value`: Output<String>) {
        this.payloadType = value
    }

    /**
     * @param value The names of the fields in the request payload that contain your customer's primary phone number. See `phone_number_fields` for more details.
     */
    @JvmName("fmhhjletapylhapm")
    public suspend fun phoneNumberFields(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPhoneNumberFieldsArgs>) {
        this.phoneNumberFields = value
    }

    /**
     * @param value Details about your login page username field. See `username_field` for more details.
     */
    @JvmName("itbralextgowajvf")
    public suspend fun usernameField(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionUsernameFieldArgs>) {
        this.usernameField = value
    }

    /**
     * @param value The names of the fields in the request payload that contain your customer's primary physical address. See `address_fields` for more details.
     */
    @JvmName("mhlmfxkopypmepkt")
    public suspend fun addressFields(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionAddressFieldsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressFields = mapped
    }

    /**
     * @param argument The names of the fields in the request payload that contain your customer's primary physical address. See `address_fields` for more details.
     */
    @JvmName("okeiudqahhsnblke")
    public suspend fun addressFields(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionAddressFieldsArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionAddressFieldsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.addressFields = mapped
    }

    /**
     * @param value The name of the field in the request payload that contains your customer's email. See `email_field` for more details.
     */
    @JvmName("dgblfnhkuhuvwhwu")
    public suspend fun emailField(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionEmailFieldArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailField = mapped
    }

    /**
     * @param argument The name of the field in the request payload that contains your customer's email. See `email_field` for more details.
     */
    @JvmName("tdmtlnismfvjbumm")
    public suspend fun emailField(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionEmailFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionEmailFieldArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.emailField = mapped
    }

    /**
     * @param value Details about your login page password field. See `password_field` for more details.
     */
    @JvmName("stojfssvahgrdmgp")
    public suspend fun passwordField(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPasswordFieldArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordField = mapped
    }

    /**
     * @param argument Details about your login page password field. See `password_field` for more details.
     */
    @JvmName("lcxrvujeuvblqgdt")
    public suspend fun passwordField(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPasswordFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPasswordFieldArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.passwordField = mapped
    }

    /**
     * @param value The payload type for your login endpoint, either JSON or form encoded.
     */
    @JvmName("drqgpkjhiaupvoej")
    public suspend fun payloadType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.payloadType = mapped
    }

    /**
     * @param value The names of the fields in the request payload that contain your customer's primary phone number. See `phone_number_fields` for more details.
     */
    @JvmName("npqwawhbanysckux")
    public suspend fun phoneNumberFields(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPhoneNumberFieldsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumberFields = mapped
    }

    /**
     * @param argument The names of the fields in the request payload that contain your customer's primary phone number. See `phone_number_fields` for more details.
     */
    @JvmName("glhguytqtetgamhc")
    public suspend fun phoneNumberFields(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPhoneNumberFieldsArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionPhoneNumberFieldsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.phoneNumberFields = mapped
    }

    /**
     * @param value Details about your login page username field. See `username_field` for more details.
     */
    @JvmName("wwtcjjckvuwmxeva")
    public suspend fun usernameField(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionUsernameFieldArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernameField = mapped
    }

    /**
     * @param argument Details about your login page username field. See `username_field` for more details.
     */
    @JvmName("nnaipoghnbkndrla")
    public suspend fun usernameField(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionUsernameFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionUsernameFieldArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.usernameField = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs =
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspectionArgs(
            addressFields = addressFields,
            emailField = emailField,
            passwordField = passwordField,
            payloadType = payloadType ?: throw PulumiNullFieldException("payloadType"),
            phoneNumberFields = phoneNumberFields,
            usernameField = usernameField,
        )
}
