@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionBodyContainsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property failureStrings Strings in the body of the response that indicate a failed login attempt.
 * @property successStrings Strings in the body of the response that indicate a successful login attempt.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionBodyContainsArgs(
    public val failureStrings: Output<List<String>>,
    public val successStrings: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionBodyContainsArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionBodyContainsArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionBodyContainsArgs.builder()
            .failureStrings(failureStrings.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .successStrings(successStrings.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionBodyContainsArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionBodyContainsArgsBuilder
internal constructor() {
    private var failureStrings: Output<List<String>>? = null

    private var successStrings: Output<List<String>>? = null

    /**
     * @param value Strings in the body of the response that indicate a failed login attempt.
     */
    @JvmName("wvcxnxcdkdsrcets")
    public suspend fun failureStrings(`value`: Output<List<String>>) {
        this.failureStrings = value
    }

    @JvmName("xfyfdyrhgdxooyii")
    public suspend fun failureStrings(vararg values: Output<String>) {
        this.failureStrings = Output.all(values.asList())
    }

    /**
     * @param values Strings in the body of the response that indicate a failed login attempt.
     */
    @JvmName("asfuwkkjjcnqmfwq")
    public suspend fun failureStrings(values: List<Output<String>>) {
        this.failureStrings = Output.all(values)
    }

    /**
     * @param value Strings in the body of the response that indicate a successful login attempt.
     */
    @JvmName("idriobjwljddbmem")
    public suspend fun successStrings(`value`: Output<List<String>>) {
        this.successStrings = value
    }

    @JvmName("nngybnqjbnaadjwc")
    public suspend fun successStrings(vararg values: Output<String>) {
        this.successStrings = Output.all(values.asList())
    }

    /**
     * @param values Strings in the body of the response that indicate a successful login attempt.
     */
    @JvmName("nlyossyevaujskxs")
    public suspend fun successStrings(values: List<Output<String>>) {
        this.successStrings = Output.all(values)
    }

    /**
     * @param value Strings in the body of the response that indicate a failed login attempt.
     */
    @JvmName("affgxvguhcmytplu")
    public suspend fun failureStrings(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureStrings = mapped
    }

    /**
     * @param values Strings in the body of the response that indicate a failed login attempt.
     */
    @JvmName("iupeufkpagtraenw")
    public suspend fun failureStrings(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureStrings = mapped
    }

    /**
     * @param value Strings in the body of the response that indicate a successful login attempt.
     */
    @JvmName("aidrsebvwspugaaq")
    public suspend fun successStrings(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.successStrings = mapped
    }

    /**
     * @param values Strings in the body of the response that indicate a successful login attempt.
     */
    @JvmName("gbygbmsxbomsgblf")
    public suspend fun successStrings(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.successStrings = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionBodyContainsArgs =
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionBodyContainsArgs(
            failureStrings = failureStrings ?: throw PulumiNullFieldException("failureStrings"),
            successStrings = successStrings ?: throw PulumiNullFieldException("successStrings"),
        )
}
