@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property failureValues Values in the response header with the specified name that indicate a failed login attempt.
 * @property name The name of the header to use.
 * @property successValues Values in the response header with the specified name that indicate a successful login attempt.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionHeaderArgs(
    public val failureValues: Output<List<String>>,
    public val name: Output<String>,
    public val successValues: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionHeaderArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionHeaderArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionHeaderArgs.builder()
            .failureValues(failureValues.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .successValues(successValues.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionHeaderArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionHeaderArgsBuilder
internal constructor() {
    private var failureValues: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var successValues: Output<List<String>>? = null

    /**
     * @param value Values in the response header with the specified name that indicate a failed login attempt.
     */
    @JvmName("arfnwjhormifdoci")
    public suspend fun failureValues(`value`: Output<List<String>>) {
        this.failureValues = value
    }

    @JvmName("vxyydfmxoyvdaxhx")
    public suspend fun failureValues(vararg values: Output<String>) {
        this.failureValues = Output.all(values.asList())
    }

    /**
     * @param values Values in the response header with the specified name that indicate a failed login attempt.
     */
    @JvmName("fnnjtjquublyvkyc")
    public suspend fun failureValues(values: List<Output<String>>) {
        this.failureValues = Output.all(values)
    }

    /**
     * @param value The name of the header to use.
     */
    @JvmName("eruslmlaboujvlnn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Values in the response header with the specified name that indicate a successful login attempt.
     */
    @JvmName("vtukxyusspjasjqr")
    public suspend fun successValues(`value`: Output<List<String>>) {
        this.successValues = value
    }

    @JvmName("ftxgmyjdlfgbuigc")
    public suspend fun successValues(vararg values: Output<String>) {
        this.successValues = Output.all(values.asList())
    }

    /**
     * @param values Values in the response header with the specified name that indicate a successful login attempt.
     */
    @JvmName("yrktsyphvrnmfybh")
    public suspend fun successValues(values: List<Output<String>>) {
        this.successValues = Output.all(values)
    }

    /**
     * @param value Values in the response header with the specified name that indicate a failed login attempt.
     */
    @JvmName("hwkywwvyahcghxfo")
    public suspend fun failureValues(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureValues = mapped
    }

    /**
     * @param values Values in the response header with the specified name that indicate a failed login attempt.
     */
    @JvmName("lmeksqblwgtdpvxc")
    public suspend fun failureValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureValues = mapped
    }

    /**
     * @param value The name of the header to use.
     */
    @JvmName("reqpymigmgceaood")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Values in the response header with the specified name that indicate a successful login attempt.
     */
    @JvmName("bbofyohbnbbhfdbb")
    public suspend fun successValues(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.successValues = mapped
    }

    /**
     * @param values Values in the response header with the specified name that indicate a successful login attempt.
     */
    @JvmName("vyslntvmephphydm")
    public suspend fun successValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.successValues = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionHeaderArgs =
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspectionHeaderArgs(
            failureValues = failureValues ?: throw PulumiNullFieldException("failureValues"),
            name = name ?: throw PulumiNullFieldException("name"),
            successValues = successValues ?: throw PulumiNullFieldException("successValues"),
        )
}
