@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property enableRegexInPath Whether or not to allow the use of regular expressions in the login page path.
 * @property loginPath The path of the login endpoint for your application.
 * @property requestInspection The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage. See `request_inspection` for more details.
 * @property responseInspection The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. Note that Response Inspection is available only on web ACLs that protect CloudFront distributions. See `response_inspection` for more details.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgs(
    public val enableRegexInPath: Output<Boolean>? = null,
    public val loginPath: Output<String>,
    public val requestInspection: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgs>? =
        null,
    public val responseInspection: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgs.builder()
            .enableRegexInPath(enableRegexInPath?.applyValue({ args0 -> args0 }))
            .loginPath(loginPath.applyValue({ args0 -> args0 }))
            .requestInspection(requestInspection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .responseInspection(
                responseInspection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgsBuilder
internal constructor() {
    private var enableRegexInPath: Output<Boolean>? = null

    private var loginPath: Output<String>? = null

    private var requestInspection:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgs>? =
        null

    private var responseInspection:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionArgs>? =
        null

    /**
     * @param value Whether or not to allow the use of regular expressions in the login page path.
     */
    @JvmName("dmyyoursqbnjaagv")
    public suspend fun enableRegexInPath(`value`: Output<Boolean>) {
        this.enableRegexInPath = value
    }

    /**
     * @param value The path of the login endpoint for your application.
     */
    @JvmName("umokvlpgjvhtinol")
    public suspend fun loginPath(`value`: Output<String>) {
        this.loginPath = value
    }

    /**
     * @param value The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage. See `request_inspection` for more details.
     */
    @JvmName("ywrokgdvupynxxpf")
    public suspend fun requestInspection(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgs>) {
        this.requestInspection = value
    }

    /**
     * @param value The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. Note that Response Inspection is available only on web ACLs that protect CloudFront distributions. See `response_inspection` for more details.
     */
    @JvmName("ujqtoaqnggycorxq")
    public suspend fun responseInspection(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionArgs>) {
        this.responseInspection = value
    }

    /**
     * @param value Whether or not to allow the use of regular expressions in the login page path.
     */
    @JvmName("ndjcvxbbuxdvbrts")
    public suspend fun enableRegexInPath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRegexInPath = mapped
    }

    /**
     * @param value The path of the login endpoint for your application.
     */
    @JvmName("gcltmvafpkkulknq")
    public suspend fun loginPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loginPath = mapped
    }

    /**
     * @param value The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage. See `request_inspection` for more details.
     */
    @JvmName("blvfulryjpxikwes")
    public suspend fun requestInspection(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestInspection = mapped
    }

    /**
     * @param argument The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage. See `request_inspection` for more details.
     */
    @JvmName("arijhxanrfohtnkp")
    public suspend fun requestInspection(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.requestInspection = mapped
    }

    /**
     * @param value The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. Note that Response Inspection is available only on web ACLs that protect CloudFront distributions. See `response_inspection` for more details.
     */
    @JvmName("keucwvvhdoaomcnk")
    public suspend fun responseInspection(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseInspection = mapped
    }

    /**
     * @param argument The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. Note that Response Inspection is available only on web ACLs that protect CloudFront distributions. See `response_inspection` for more details.
     */
    @JvmName("xnqitwqyeljlvyoh")
    public suspend fun responseInspection(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.responseInspection = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgs =
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetArgs(
            enableRegexInPath = enableRegexInPath,
            loginPath = loginPath ?: throw PulumiNullFieldException("loginPath"),
            requestInspection = requestInspection,
            responseInspection = responseInspection,
        )
}
